/* 
 * hci.c --  Implementation of Bluetooth Host Controller Interface following
 *           the UART transport layer 
 *
 * Copyright (C) 2000  Axis Communications AB
 *
 * Mats Friden <mats.friden@axis.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Id: hci.h,v 1.34 2000/11/24 13:41:02 johanz Exp $
 *
 */

#ifndef HCI_H
#define HCI_H

/****************** INCLUDE FILES SECTION ***********************************/

#ifdef __KERNEL__
#include <linux/types.h>
#include <linux/bluetooth/btcommon.h>
#else
#include "local.h"
#include "btcommon.h"
#endif

/****************** CONSTANT AND MACRO SECTION ******************************/

#define INQUIRY_SCAN_ENABLE 1
#define PAGE_SCAN_ENABLE 2
 
/****************** EXPORTED FUNCTION DECLARATION SECTION *******************/

void hci_init(void);
void hci_clear_buffer(u32 con_hdl);
void hci_receive_data(u8* data, u32 count);
s32 hci_send_data(bt_tx_buf *tx_buf);

s32 lp_connect_req(u8 bd_addr[]);
s32 lp_connect_rsp(u8 bd_addr[], u32 cfm);
s32 lp_disconnect(u32 con_hdl);

u8* get_err_msg(u32 err_code);
s32 get_client_bd_addr(u8 *bd);

s32 hci_sprint_remote_info(u8 *buf);
s32 hci_sprint_local_info(u8 *buf);
s32 hci_sprint_local_bd(u8 *buf);

inquiry_results* hci_inquiry(u8 lap[], u8 inq_len, u8 num_resp);
s32 hci_add_sco_connection(u32 hci_hdl);

/* Host Controller and Baseband Commands */
s32 hci_reset(void);
s32 hci_change_local_name(u8 *new_name);
s32 hci_write_scan_enable(u32 enable);
s32 hci_write_pagescan_activity(u32 interval, u32 wind);
s32 hci_read_link_supervision_to(u32 hdl);
s32 hci_write_link_supervision_to(u32 hdl, u32 link_to);

/* Informational Parameters */
s32 hci_read_local_bd(u8 *bd);

/* Internal */
/* FIXME -- add parameter to choose from different devices */
s32 get_remote_bd(u8 *bd);

/* Testing commands */
s32 hci_enable_dut(void);
s32 hci_test_connect_req(u8 *bd);
s32 hci_send_raw_data(u8 * data);

/* Vendor specific */
s32 hci_set_bd_addr(u8 bd[6]);
s32 hci_set_baudrate(u32 baudrate); 
s32 hci_read_firmware_rev_info(void);

#endif
/****************** END OF FILE hci.h ***************************************/
