/* 
 * btmem.h --  Memory management in Bluetooth stack
 *
 * Copyright (C) 2000  Axis Communications AB
 *
 * Mattias Agren <mattias.agren@axis.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Id: btmem.h,v 1.16 2000/10/13 11:02:53 mattias Exp $x
 *
 */

#ifndef BTMEM_H
#define BTMEM_H

/****************** INCLUDE FILES SECTION ***********************************/

#ifdef __KERNEL__
#include <linux/types.h>
#include <linux/bluetooth/btcommon.h>
#else
#include "btcommon.h"
#endif

/****************** CONSTANT AND MACRO SECTION ******************************/

/* There should be less than this amomunt of data in the buffer before we wake
   up the ldisc */
#define BTMEM_UNTHROTTLE_SIZE 512

/****************** TYPE DEFINITION SECTION *********************************/

/****************** EXPORTED FUNCTION DECLARATION SECTION *******************/

/* Allocated the whole buffer and initates main object */
void btmem_init(void);

/* Deallocates the whole buffer */
void btmem_shutdown(void);

/* Subscribes one memory object (bt_tx_buf) with payload_len bytes in the 
   data segment. */
bt_tx_buf* subscribe_bt_buf(s32 send_len);

/* Fetch pointer to next transmission chunk, returns > 0 if data available, 
   0 if buffer empty, < 0 error. If bt_tx_buf object has flushed flag set
   simply unsubscribe and proceed to next */
bt_tx_buf* get_bt_buf(void);

/* Returns number of buffers */
s32 buf_count(void);

/* Returns total number of bytes in buffer (fragmented) */
s32 buf_byte_count(void);

/* Returns unfragmented buffer space */ 
s32 buf_write_room(void);

/* Is run whenever buffer is empty */
void btmem_reset(void);

/* Marks all buffers on hci handle hdl as flushed */
void btmem_flushhandle(u16 hdl);

/* Unsubscribes memory area so other functions can reuse that memory. */
void unsubscribe_bt_buf(bt_tx_buf *tx);

void show_bt_buf(bt_tx_buf *tx, s32 no_data); /* Set no_data true to leave
                                                 out data field print*/

void btmem_get_status(bt_tx_buf *current_buf);
void btmem_show_size(s32 count);
void btmem_test(void);

#endif
/****************** END OF FILE btmem.h *************************************/
