/* 
 * btconfig.h -- Configuration/Test defines for the Bluetooth stack          
 *
 * Copyright (C) 2000  Axis Communications AB
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Id: btconfig.h,v 1.6 2000/11/13 15:43:28 matsf Exp $
 *
 */

/******************
 *    General     *
 ******************/

/* use of /proc files to read status information */
#define BT_USE_PROC

/* Bluetooth HW defines used to setup different HW and to cope with 
   limitations in HW */

#define HW_NOINIT 0
#define HW_ERICSSON 1
#define HW_DIGIANSWER_PC 2
#define HW_DIGIANSWER_RS232 3
#define HW_CSR 4
#define HW_XIRCOMM 5
#define HW_USBMODULE 6 /* same for all brands ? */

#define HW_DEFAULT HW_ERICSSON


/***************
 *     HCI     *
 ***************/

/* 
   HCI emulation enables using the stack without any bluetooth hardware. 
   With this option defined you can test the stack by connecting two Linux 
   machines with a nullmodem cabel. (If you are defining this you must start 
   btd with no hw init) 
*/

//#define HCI_EMULATION

/* This should be defined if you are using the Ericsson P9A firmware */
#define P9A

//#define HOST_FLOW_CTRL
/* This define is used during test of the host flow control */

#ifdef __KERNEL__
/* Don't define these four, they are only used for AXIS internal tests */
//#define EMC_TEST
//#define EMC_TEST_INITIATOR
//#define EMC_LISTNER_ADDR 0x1810ce
//#define EMC_TEST_DATA_SIZE 678
#endif

#define HCI_USEUSB

/****************
 *     L2CAP    *
 ****************/

#define L2CAP_USETIMERS
#define DEF_ALLOWCONLESS 0

/*****************
 *     RFCOMM    *
 *****************/



/***************
 *     SDP     *
 ***************/
