/* $Id: system.h,v 1.14 1999/08/09 08:52:16 hp Exp $ */

#ifndef __ASM_SYSTEM_H
#define __ASM_SYSTEM_H

#include <asm/segment.h>

/* I need a task-specific debug struct (and the define for #ifdef
   RELOC_DEBUG) to kludge into task_struct. */
#include <linux/config.h>
#include <asm/eshlibld.h>

/*
 * Entry into gdt where to find first TSS. GDT layout:
 *   0 - null
 *   1 - not used
 *   2 - kernel code segment
 *   3 - kernel data segment
 *   4 - user code segment
 *   5 - user data segment
 * ...
 *   8 - TSS #0
 *   9 - LDT #0
 *  10 - TSS #1
 *  11 - LDT #1
 */
#define FIRST_TSS_ENTRY 8
#define FIRST_LDT_ENTRY (FIRST_TSS_ENTRY+1)
#define _TSS(n) ((((unsigned long) n)<<4)+(FIRST_TSS_ENTRY<<3))
#define _LDT(n) ((((unsigned long) n)<<4)+(FIRST_LDT_ENTRY<<3))
#define load_TR(n)
#define load_ldt(n)
#define store_TR(n)

/* This special macro can be used to load a debugging register */

#define loaddebug(tsk,register)

/* the switch_to macro calls resume, an asm function in entry.S which does the actual
 * task switching.
 */

extern void resume(void *, void *, int);
#define switch_to(prev,next) resume(prev,next,(int)&((struct task_struct *)0)->tss)

#define _set_base(addr,base)

#define _set_limit(addr,limit)

#define set_base(ldt,base) _set_base( ((char *)&(ldt)) , base )
#define set_limit(ldt,limit) _set_limit( ((char *)&(ldt)) , (limit-1)>>12 )

extern inline unsigned long rdusp(void) {
	unsigned long usp;
	__asm__ __volatile__("move.d sp,%0" : "=rm" (usp));
	return usp;
}

#define wrusp(usp) \
	__asm__ __volatile__("move.d %0,sp" : /* no outputs */ : "rm" (usp))

static inline unsigned long _get_base(char * addr)
{
  return 0;
}

#define get_base(ldt) _get_base( ((char *)&(ldt)) )

static inline unsigned long get_limit(unsigned long segment)
{
  return 0;
}

#define nop() __asm__ __volatile__ ("nop");

/*
 * Clear and set 'TS' bit respectively
 */
#define clts()
#define stts()

#define xchg(ptr,x) ((__typeof__(*(ptr)))__xchg((unsigned long)(x),(ptr),sizeof(*(ptr))))
#define tas(ptr) (xchg((ptr),1))

struct __xchg_dummy { unsigned long a[100]; };
#define __xg(x) ((struct __xchg_dummy *)(x))

#if 0
#define sti() __asm__ __volatile__ ( "ei\n\tpush r0\n\tmoveq 0,r0\n\tmove.d r0,[0x90000000]\n\tpop r0" );
#define cli() __asm__ __volatile__ ( "di\n\tpush r0\n\tmove.d 0x40000,r0\n\tmove.d r0,[0x90000000]\n\tpop r0");
#define save_flags(x) __asm__ __volatile__ ("move ccr,%0" : "=rm" (x) : : "memory");
#define restore_flags(x) __asm__ __volatile__ ("move %0,ccr\n\tbtstq 5,%0\n\tbpl 1f\n\tnop\n\tpush r0\n\tmoveq 0,r0\n\tmove.d r0,[0x90000000]\n\tpop r0\n1:\n" : : "r" (x) : "memory");
#else
#define cli() __asm__ __volatile__ ( "di");
#define sti() __asm__ __volatile__ ( "ei" );
#define save_flags(x) __asm__ __volatile__ ("move ccr,%0" : "=rm" (x) : : "memory");
#define restore_flags(x) __asm__ __volatile__ ("move %0,ccr" : : "rm" (x) : "memory");
#endif


static inline unsigned long __xchg(unsigned long x, void * ptr, int size)
{
  /* since Etrax doesn't have any atomic xchg instructions, we need to disable
     irq's (if enabled) and do it with move.d's */
#if 0
  unsigned int flags;
  save_flags(flags); /* save flags, including irq enable bit */
  cli();             /* shut off irq's */
  switch (size) {
  case 1:
    __asm__ __volatile__ (
       "move.b %0,r0\n\t"
       "move.b %1,%0\n\t"
       "move.b r0,%1\n\t"
       : "=r" (x)
       : "m" (*__xg(ptr)), "r" (x)
       : "memory","r0");    
    break;
  case 2:
    __asm__ __volatile__ (
       "move.w %0,r0\n\t"
       "move.w %1,%0\n\t"
       "move.w r0,%1\n\t"
       : "=r" (x)
       : "m" (*__xg(ptr)), "r" (x)
       : "memory","r0");
    break;
  case 4:
    __asm__ __volatile__ (
       "move.d %0,r0\n\t"
       "move.d %1,%0\n\t"
       "move.d r0,%1\n\t"
       : "=r" (x)
       : "m" (*__xg(ptr)), "r" (x)
       : "memory","r0");
    break;
  }
  restore_flags(flags); /* restore irq enable bit */
  return x;
#else
  unsigned long flags,temp;
  save_flags(flags); /* save flags, including irq enable bit */
  cli();             /* shut off irq's */
  switch (size) {
  case 1:
    *((unsigned char *)&temp) = x;
    x = *(unsigned char *)ptr;
    *(unsigned char *)ptr = *((unsigned char *)&temp);
    break;
  case 2:
    *((unsigned short *)&temp) = x;
    x = *(unsigned short *)ptr;
    *(unsigned short *)ptr = *((unsigned short *)&temp);
    break;
  case 4:
    temp = x;
    x = *(unsigned long *)ptr;
    *(unsigned long *)ptr = temp;
    break;
  }
  restore_flags(flags); /* restore irq enable bit */
  return x;
#endif
}

#define mb()

#define iret()

#define _set_seg_desc(gate_addr,type,dpl,base,limit) {\
	*((gate_addr)+1) = ((base) & 0xff000000) | \
		(((base) & 0x00ff0000)>>16) | \
		((limit) & 0xf0000) | \
		((dpl)<<13) | \
		(0x00408000) | \
		((type)<<8); \
	*(gate_addr) = (((base) & 0x0000ffff)<<16) | \
		((limit) & 0x0ffff); }

#define _set_tssldt_desc(n,addr,limit,type)

#define set_tss_desc(n,addr) _set_tssldt_desc(((char *) (n)),((int)(addr)),235,"0x89")
#define set_ldt_desc(n,addr,size) \
	_set_tssldt_desc(((char *) (n)),((int)(addr)),((size << 3) - 1),"0x82")

/*
 * This is the ldt that every process will get unless we need
 * something other than this.
 */
extern struct desc_struct default_ldt;

/*
 * disable hlt during certain critical i/o operations
 */
#define HAVE_DISABLE_HLT
void disable_hlt(void);
void enable_hlt(void);

#endif
