
#define DMA_DESCR__out_priority__BITNR  5
#define DMA_DESCR__out_priority__WIDTH  1
#define DMA_DESCR__out_priority__normal 0
#define DMA_DESCR__out_priority__high   1

#define DMA_DESCR__ecp_cmd__BITNR  4
#define DMA_DESCR__ecp_cmd__WIDTH  1
#define DMA_DESCR__ecp_cmd__normal 0
#define DMA_DESCR__ecp_cmd__high   1

#define DMA_DESCR__tx_err__BITNR 4
#define DMA_DESCR__tx_err__WIDTH 1
#define DMA_DESCR__tx_err__enable 1
#define DMA_DESCR__tx_err__disable 0

#define DMA_DESCR__intr__BITNR  3
#define DMA_DESCR__intr__WIDTH  1
#define DMA_DESCR__intr__enable 1
#define DMA_DESCR__intr__disable 0

#define DMA_DESCR__wait__BITNR 2
#define DMA_DESCR__wait__WIDTH 1
#define DMA_DESCR__wait__enable 1
#define DMA_DESCR__wait__disable 0

#define DMA_DESCR__eop__BITNR 1
#define DMA_DESCR__eop__WIDTH 1
#define DMA_DESCR__eop__enable 1
#define DMA_DESCR__eop__disable 0

#define DMA_DESCR__eol__BITNR 0
#define DMA_DESCR__eol__WIDTH 1
#define DMA_DESCR__eol__enable 1
#define DMA_DESCR__eol__disable 0

#define DMA_DESCR__sw_len__BITNR 0
#define DMA_DESCR__sw_len__WIDTH 16

#define DMA_DESCR__next__BITNR 0
#define DMA_DESCR__next__WIDTH 32

#define DMA_DESCR__buf__BITNR 0
#define DMA_DESCR__buf__WIDTH 32

#define DMA_DESCR__fifo_len__BITNR 8
#define DMA_DESCR__fifo_len__WIDTH 7

#define DMA_DESCR__crc_err__BITNR 7
#define DMA_DESCR__crc_err__WIDTH 1
#define DMA_DESCR__crc_err__enable 1
#define DMA_DESCR__crc_err__disable 0

#define DMA_DESCR__align_err__BITNR 6
#define DMA_DESCR__align_err__WIDTH 1
#define DMA_DESCR__align_err__enable 1
#define DMA_DESCR__align_err__disable 0

#define DMA_DESCR__in_priority__BITNR 5
#define DMA_DESCR__in_priority__WIDTH 1
#define DMA_DESCR__in_priority__high 1
#define DMA_DESCR__in_priority__normal 0

#define DMA_DESCR__stop__BITNR 4
#define DMA_DESCR__stop__WIDTH 1

#define DMA_DESCR__rd_eop__BITNR 1
#define DMA_DESCR__rd_eop__WIDTH 1

#define DMA_DESCR__hw_len__BITNR 0
#define DMA_DESCR__hw_len__WIDTH 16

#define SET_ETHER_ADDR(a0_0,a0_1,a0_2,a0_3,a0_4,a0_5,a1_0,a1_1,a1_2,a1_3,a1_4,a1_5) \
  *R_NETWORK_SA_0 = a0_0 | (a0_1 << 8) | (a0_2 << 16) | (a0_3 << 24); \
  *R_NETWORK_SA_1 = a0_4 | (a0_5 << 8) | (a1_0 << 16) | (a1_1 << 24); \
  *R_NETWORK_SA_2 = a1_2 | (a1_3 << 8) | (a1_4 << 16) | (a1_5 << 24);

#define CRC_LEN 4

#define TRUE  1
#define FALSE 0

#define SERIAL   0
#define NETWORK  1
#define PARALLEL 2

#define STRING 0
#define INT    1
#define ACK    2
#define BOOT_PACKET 4

#define JUMP           1
#define MEM_TEST       2
#define PACKET_INFO    3
#define SET_REGISTER   4
#define GET_REGISTER   5
#define MEM_DUMP       6
#define MEM_CLEAR      7

#define TIMEOUT_LIMIT ( ((6250 * 1000) / 0xffff) / 2)

#define ntohl(x) \
((unsigned long int)((((unsigned long int)(x) & 0x000000ffU) << 24) | \
		     (((unsigned long int)(x) & 0x0000ff00U) <<  8) | \
		     (((unsigned long int)(x) & 0x00ff0000U) >>  8) | \
		     (((unsigned long int)(x) & 0xff000000U) >> 24)))
     
#define htonl(x) ntohl(x)

#define TX_CTRL_EOP \
(IO_STATE(DMA_DESCR, intr, disable) |\
 IO_STATE(DMA_DESCR, wait, enable)  |\
 IO_STATE(DMA_DESCR, eop,  enable)  |\
 IO_STATE(DMA_DESCR, eol,  enable))
     
#define TX_CTRL \
     (IO_STATE(DMA_DESCR, intr, disable) |\
      IO_STATE(DMA_DESCR, wait, disable) |\
      IO_STATE(DMA_DESCR, eop,  disable) |\
      IO_STATE(DMA_DESCR, eol,  disable))
     
#define SERIAL_CTRL_W \
     ((IO_STATE(R_SERIAL0_CTRL, tr_baud,       c9600Hz) |\
       IO_STATE(R_SERIAL0_CTRL, rec_baud,      c9600Hz) |\
       IO_STATE(R_SERIAL0_CTRL, dma_err,       stop)     |\
       IO_STATE(R_SERIAL0_CTRL, rec_enable,    enable)   |\
       IO_STATE(R_SERIAL0_CTRL, rts_,          active)   |\
       IO_STATE(R_SERIAL0_CTRL, sampling,      middle)   |\
       IO_STATE(R_SERIAL0_CTRL, rec_stick_par, normal)   |\
       IO_STATE(R_SERIAL0_CTRL, rec_par,       even)     |\
       IO_STATE(R_SERIAL0_CTRL, rec_par_en,    disable)  |\
       IO_STATE(R_SERIAL0_CTRL, rec_bitnr,     rec_8bit)) >> 16)

#define SERIAL_CTRL_B \
     ((IO_FIELD(R_SERIAL0_CTRL, txd, 0)                  |\
       IO_STATE(R_SERIAL0_CTRL, tr_enable,     enable)   |\
       IO_STATE(R_SERIAL0_CTRL, auto_cts,      disabled) |\
       IO_STATE(R_SERIAL0_CTRL, stop_bits,     one_bit)  |\
       IO_STATE(R_SERIAL0_CTRL, tr_stick_par,  normal)   |\
       IO_STATE(R_SERIAL0_CTRL, tr_par,        even)     |\
       IO_STATE(R_SERIAL0_CTRL, tr_par_en,     disable)  |\
       IO_STATE(R_SERIAL0_CTRL, tr_bitnr,      tr_8bit)) >> 8)
     
#define R_PAR0_CONFIG_SETUP \
     (IO_STATE (R_PAR0_CONFIG, ioe,     noninv)    |\
      IO_STATE (R_PAR0_CONFIG, iseli,   noninv)    |\
      IO_STATE (R_PAR0_CONFIG, iautofd, noninv)    |\
      IO_STATE (R_PAR0_CONFIG, istrb,   noninv)    |\
      IO_STATE (R_PAR0_CONFIG, iinit,   noninv)    |\
      IO_STATE (R_PAR0_CONFIG, iperr,   noninv)    |\
      IO_STATE (R_PAR0_CONFIG, iack,    noninv)    |\
      IO_STATE (R_PAR0_CONFIG, ibusy,   noninv)    |\
      IO_STATE (R_PAR0_CONFIG, ifault,  noninv)    |\
      IO_STATE (R_PAR0_CONFIG, isel,    noninv)    |\
      IO_STATE (R_PAR0_CONFIG, dma,     disable)   |\
      IO_STATE (R_PAR0_CONFIG, rle_in,  disable)   |\
      IO_STATE (R_PAR0_CONFIG, rle_out, disable)   |\
      IO_STATE (R_PAR0_CONFIG, enable,  on)        |\
      IO_STATE (R_PAR0_CONFIG, force,   off)       |\
      IO_STATE (R_PAR0_CONFIG, ign_ack, wait)      |\
      IO_STATE (R_PAR0_CONFIG, oe_ack,  dont_wait) |\
      IO_STATE (R_PAR0_CONFIG, mode,    ecp_rev))

#define R_GEN_CONFIG_SETUP \
     (IO_STATE (R_GEN_CONFIG, g24dir,    in)      |\
      IO_STATE (R_GEN_CONFIG, g16_20dir, in)      |\
      IO_STATE (R_GEN_CONFIG, g8_15dir,  in)      |\
      IO_STATE (R_GEN_CONFIG, g0dir,     in)      |\
      IO_STATE (R_GEN_CONFIG, dma9,      unused)  |\
      IO_STATE (R_GEN_CONFIG, dma8,      unused)  |\
      IO_STATE (R_GEN_CONFIG, dma7,      unused)  |\
      IO_STATE (R_GEN_CONFIG, dma6,      unused)  |\
      IO_STATE (R_GEN_CONFIG, dma5,      par1)  /* Unused, so par1 is ok, =0 */ |\
      IO_STATE (R_GEN_CONFIG, dma4,      par1)  /* Unused, so par1 is ok, =0 */ |\
      IO_STATE (R_GEN_CONFIG, dma3,      scsi0) /* Unused, (must not be 0) */ |\
      IO_STATE (R_GEN_CONFIG, dma2,      scsi0) /* Unused  (must not be 0) */ |\
      IO_STATE (R_GEN_CONFIG, mio_w,     disable) |\
      IO_STATE (R_GEN_CONFIG, ser3,      disable) |\
      IO_STATE (R_GEN_CONFIG, par1,      disable) |\
      IO_STATE (R_GEN_CONFIG, scsi0w,    disable) |\
      IO_STATE (R_GEN_CONFIG, scsi1,     disable) |\
      IO_STATE (R_GEN_CONFIG, mio,       disable) |\
      IO_STATE (R_GEN_CONFIG, ser2,      disable) |\
      IO_STATE (R_GEN_CONFIG, par0,      select)  |\
      IO_STATE (R_GEN_CONFIG, ata,       disable) |\
      IO_STATE (R_GEN_CONFIG, scsi0,     disable))
     
#define LOAD_ADDRESS 0x38001000    
#define SIZEOF_BOOT_LEVEL_1 2048

#define DB 0

#if DB == 1
#define print_int(a) \
*(volatile int*) 0x84000004 = a;\
*(volatile unsigned char*) 0x84000000 = 15;

#define print_hex(a) \
*(volatile int*) 0x84000004 = a;\
*(volatile unsigned char*) 0x84000000 = 22;
#else
#define print_int(a)
#define print_hex(a)
#endif

#define IO_BUF_START	0x38001f00
#define IO_BUF_END	0x38001fff

#define byte   unsigned char
#define uword  unsigned short
#define udword unsigned int
#define dword  signed int

typedef struct packet_header_T	/* Size = 38 */
{  
  byte      dest[6];
  byte      src[6];
  byte      length[2];
  udword    snap1;
  udword    snap2;
  udword    tag;		
  udword    seq;
  udword    type;
  udword    id;    
} packet_header_T;

typedef struct dma_descr_T {
  uword  sw_len;                /* 0-1 */
  uword  ctrl;                  /* 2-3 */
  udword next;                  /* 4-7 */
  udword buf;                   /* 8-11 */
  uword  hw_len;                /* 12-13 */
  uword  status;                /* 14-15 */
} dma_descr_T;

typedef struct packet_info_T {
  udword type;
  udword addr;
  udword size;
} packet_info_T;

typedef struct set_register_T {
  udword type;
  udword addr;
  udword val;
} set_register_T;

typedef struct get_register_T {
  udword type;
  udword addr;
} get_register_T;

typedef struct mem_test_T {
  udword type;
  udword addr;
  udword size;
} mem_test_T;

typedef struct mem_dump_T {
  udword type;
  udword from_addr;
  udword to_addr;
} mem_dump_T;

typedef struct mem_clear_T {
  udword type;
  udword from_addr;
  udword to_addr;
} mem_clear_T;

typedef struct jump_T {
  udword type;
  udword addr;
} jump_T;

#define NETWORK_HEADER_LENGTH sizeof(packet_header_T)

byte 		crc_correct();
void        	read_data(void);
void	 	boot_crt0(void);
void 		boot_crt1(void);
void 		send_serial_ack();
void 		send_network_ack();
void 		send_parallel_ack();
int		timeout();
void		handle_network_read();
void 		send_serial_string(char *str);
void 		send_parallel_string(char *str);
void 		send_network_string(char *str);
void		start_network_trans();
void		send_serial_loop();
void 		toggle_led();
void 		ser_print(char *str);
void            send_serial_hex(udword v);
void            send_serial_uword(uword v);
void            level2_boot();
void            ser_init();
void            net_init();
void            parallel_init();
void            read_load_info();
void            decode_load_info();
void            read_file(packet_info_T *packet_info);
void            print_descr(dma_descr_T *d);
int             memory_test(udword addr, udword size, udword *failed_address);

extern byte	*target_address;
extern udword	nbr_read;
extern byte    interface;
extern byte    set_dest;
extern udword  last_timeout;
extern byte   	*io_buf_next;
extern byte   	*io_buf_cur;

extern packet_header_T tx_header;
extern dma_descr_T tx_descr;
extern dma_descr_T tx_descr2;

extern packet_header_T rx_header;
extern dma_descr_T rx_descr;
extern dma_descr_T rx_descr2;

extern void (*send_ack[3])();
extern void (*send_string[3])();
extern void (*init_interface[3])();

extern uword timeout_limit;  
extern udword seq;

extern byte serial_up;









 



