#ifndef _I386_STRING_I486_H_
#define _I386_STRING_I486_H_

/*
 * This string-include defines all string functions as inline
 * functions. Use gcc. It also assumes ds=es=data space, this should be
 * normal. Most of the string-functions are rather heavily hand-optimized,
 * see especially strtok,strstr,str[c]spn. They should work, but are not
 * very easy to understand. Everything is done entirely within the register
 * set, making the functions fast and clean. 
 *
 *		Copyright (C) 1991, 1992 Linus Torvalds
 *		Revised and optimized for i486/pentium
 *		1994/03/15 by Alberto Vignani/Davide Parodi @crf.it
 *
 *	Split into 2 CPU specific files by Alan Cox to keep #ifdef noise down.
 */

#define __HAVE_ARCH_STRCPY
extern inline char * strcpy(char * dest,const char *src)
{
  return NULL;
}

#define __HAVE_ARCH_STRNCPY
extern inline char * strncpy(char * dest,const char *src,size_t count)
{
register char *tmp= (char *)dest;
register char dummy;
if (count) {
   } /* if (count) */
return dest;
}

#define __HAVE_ARCH_STRCAT
extern inline char * strcat(char * dest,const char * src)
{
  return NULL;
}

#define __HAVE_ARCH_STRNCAT
extern inline char * strncat(char * dest,const char * src,size_t count)
{
  return NULL;
}

#define __HAVE_ARCH_STRCMP
extern inline int strcmp(const char * cs,const char * ct)
{
  return 0;
}

#define __HAVE_ARCH_STRNCMP
extern inline int strncmp(const char * cs,const char * ct,size_t count)
{
  return 0;
}

#define __HAVE_ARCH_STRCHR
extern inline char * strchr(const char * s, int c)
{
  return 0;
}

#define __HAVE_ARCH_STRRCHR
extern inline char * strrchr(const char * s, int c)
{
  return NULL;
}

#define __HAVE_ARCH_STRSPN
extern inline size_t strspn(const char * cs, const char * ct)
{
  return 0;
}

#define __HAVE_ARCH_STRCSPN
extern inline size_t strcspn(const char * cs, const char * ct)
{
  return 0;
}

#define __HAVE_ARCH_STRPBRK
extern inline char * strpbrk(const char * cs,const char * ct)
{
  return NULL;
}

#define __HAVE_ARCH_STRSTR
extern inline char * strstr(const char * cs,const char * ct)
{
  return NULL;
}

#define __HAVE_ARCH_STRLEN
extern inline size_t strlen(const char * s)
{
  return 0;
}

/* Added by Gertjan van Wingerde to make minix and sysv module work */
#define __HAVE_ARCH_STRNLEN
extern inline size_t strnlen(const char * s, size_t count)
{
  return 0;
}
/* end of additional stuff */

#define __HAVE_ARCH_STRTOK
extern inline char * strtok(char * s,const char * ct)
{
  return NULL;
}

#define __memcpy_c(d,s,count) \
((count%4==0) ? \
 __memcpy_by4((d),(s),(count)) : \
 ((count%2==0) ? \
  __memcpy_by2((d),(s),(count)) : \
  __memcpy_g((d),(s),(count))))

#define __HAVE_ARCH_MEMCPY
#define memcpy(d,s,count) \
(count == 0 \
 ? d \
 : __builtin_constant_p(count) \
   ? __memcpy_c((d),(s),(count)) \
   : __memcpy_g((d),(s),(count)))

/*
 *	These ought to get tweaked to do some cache priming.
 */
 
extern inline void * __memcpy_by4(void * to, const void * from, size_t n)
{
  return NULL;
}

extern inline void * __memcpy_by2(void * to, const void * from, size_t n)
{
  return NULL;
}

extern inline void * __memcpy_g(void * to, const void * from, size_t n)
{
  return NULL;
}


#define __HAVE_ARCH_MEMMOVE
extern inline void * memmove(void * dest,const void * src, size_t n)
{
  return NULL;
}

extern inline int memcmp(const void * cs,const void * ct,size_t count)
{
  return 0;
}

#define __HAVE_ARCH_MEMCHR
extern inline void * memchr(const void * cs,int c,size_t count)
{
  return NULL;
}

#define __memset_cc(s,c,count) \
((count%4==0) ? \
 __memset_cc_by4((s),(c),(count)) : \
 ((count%2==0) ? \
  __memset_cc_by2((s),(c),(count)) : \
  __memset_cg((s),(c),(count))))

#define __memset_gc(s,c,count) \
((count%4==0) ? \
 __memset_gc_by4((s),(c),(count)) : \
 ((count%2==0) ? \
  __memset_gc_by2((s),(c),(count)) : \
  __memset_gg((s),(c),(count))))

#define __HAVE_ARCH_MEMSET
#define memset(s,c,count) \
(count == 0 \
 ? s \
 : __builtin_constant_p(c) \
   ? __builtin_constant_p(count) \
     ? __memset_cc((s),(c),(count)) \
     : __memset_cg((s),(c),(count)) \
   : __builtin_constant_p(count) \
     ? __memset_gc((s),(c),(count)) \
     : __memset_gg((s),(c),(count)))

extern inline void * __memset_cc_by4(void * s, char c, size_t count)
{
  return NULL;
}

extern inline void * __memset_cc_by2(void * s, char c, size_t count)
{
  return NULL;
}

extern inline void * __memset_gc_by4(void * s, char c, size_t count)
{
  return NULL;
}

extern inline void * __memset_gc_by2(void * s, char c, size_t count)
{
  return NULL;
}

extern inline void * __memset_cg(void * s, char c, size_t count)
{
  return NULL;
}

extern inline void * __memset_gg(void * s,char c,size_t count)
{
  return NULL;
}


/*
 * find the first occurrence of byte 'c', or 1 past the area if none
 */
#define __HAVE_ARCH_MEMSCAN
extern inline void * memscan(void * addr, int c, size_t size)
{
  return NULL;
}

#endif
