#ifndef __CRIS_A_OUT_H__
#define __CRIS_A_OUT_H__

#ifndef __GNU_CRIS__
#error You need to adjust this file, right now it depends on a little-endian architecture
#endif

struct aout_cris_exec
{
  char magic[4];		/* Use macros N_MAGIC, etc for access */
  unsigned a_text;		/* length of text, in bytes */
  unsigned a_data;		/* length of data, in bytes */
  unsigned a_bss;		/* length of uninitialized data area for file, in bytes */
  unsigned a_syms;		/* length of symbol table data in file, in bytes */
  unsigned a_stringsize;        /* Used to be "start address", but why start
                                   anywhere else than at the beginning (at
                                   "reserved", below.  Also saves an mmap call. */
  unsigned a_trsize;		/* length of relocation info for text, in bytes */
  unsigned a_drsize;		/* length of relocation info for data, in bytes */
};

/* These bits be located just after the aout_cris_exec struct.  They are
   not included in the aout_cris_exec struct since they may contain
   relocations; i.e. the contents is not reliable until relocations for
   the code segment are resolved.  */
struct aout_cris_exec_extra
{
  char reserved[8];		/* Jump instruction(s) to start, maybe */
  unsigned long stack_hint;	/* At least this big stack. */
};

#define N_TRSIZE(a)	((a).a_trsize)
#define N_DRSIZE(a)	((a).a_drsize)
#define N_SYMSIZE(a)	((a).a_syms)

#if 0
#ifdef __KERNEL__

#define STACK_TOP	TASK_SIZE

#endif
#endif

#endif /* __CRIS_A_OUT_H__ */
