/* RSIM/XSIM Simulator interface codes for CRIS.
   Copyright (C) 1994..2000 Axis Communications.  */
#ifndef _Rsim_Xsim_included
#define S_freopen 1
#define S_fclose 2
#define S_fflush 3
#define S_fputc 4
#define S_fgetc 5
#define S_system 6
#define S_remove 7
#define S_rename 8
#define S_tmpfile 9
#define S_tmpnam 10
#define S_fread 11
#define S_fwrite 12
#define S_fseek 13
#define S_exit 14
#define S_sbrk 15
#define S_ftell 16
#define S_clearerr 17
#define S_feof 18
#define S_ferror 19
#define S_strerror 20
#define S_getenv 21
#define S_time 22
#define S_debug 23
#define S_fsetpos 24

/* From here on not using struct.  */
#define S_idle 25
#define S_cpuid 26
#define S_cycles 27
#define S_simcycles 28
#define S_trace_on 255
#define S_trace_off 254

/* Now using struct again.  */
#define S_stat 29

struct _Partype
{
  int i, i1;
  char *s1, *s2;
  void *voidp;
  void *p1, *p2;
};

/* File operations use one of these when talking.  */
extern void *_Sim_file_cookies[32];

#define CRIS_CYCLES() __extension__ \
 ({ unsigned long c_; asm ("bmod [%1],%0" : "=r" (c_) : "r" (S_cycles)); c_;})

#define CPU_NUMBER()  __extension__ \
 ({ unsigned long c_; asm ("bmod [%1],%0" : "=r" (c_) : "r" (S_cpuid)); c_;})

#define WAIT_FOR_INTERRUPT() do { asm volatile ("bmod [%0],%0" : : "r" (S_idle)); } while (0)

#define TRACE_ON() __extension__ \
 ({ int c_; __asm__ volatile ("bmod [%0],%0" : "=r" (c_) : "0" (S_trace_on)); c_; })

#define TRACE_OFF() do { __asm__ volatile ("bmod [%0],%0" : : "r" (S_trace_off)); } while (0)

/* Not used so much; print number of cycles as well as exits with zero.  */
#define SIM_END() do { __asm__ volatile ("bmod [%0],%0" : : "r" (S_simcycles)); } while (0)

/* Exit with exit status N. */
#define SIM_EXIT(N) do { __asm__ volatile ("bmod [%0],%1" : : "r" (S_exit), "r" (N)); } while (0)

#endif /* _Rsim_Xsim_included */
