/* Low-level file support for simulator.
   Copyright (C) 1998, 1999, 2000 Axis Communications.  */

#include <stdio.h>
#include "simcodes.h"
#include <errno.h>
#undef errno
extern int errno;

int
_lseek(unsigned int file, long offset, int orig)
{
  static struct _Partype par = {0};
  int ret;

  par.i = orig;
  par.i1 = offset;

  if (file >= 32)
    {
      errno = EBADF;
      return -1;
    }

  par.voidp = _Sim_file_cookies[file];

  __asm__ volatile ("bmod [%1],%0" : "=r" (ret) : "r" (S_fseek) , "0" (&par));

  if (ret)
    {
      errno = ret;
      ret = -1;
    }
  else
    {
      __asm__ volatile ("bmod [%1],%0" : "=r" (ret) : "r" (S_ftell) , "0" (&par));

      if (ret < 0)
	{
	  errno = -ret;
	  ret = -1;
	}
    }

  return ret;
}
