/* Support for NO_MM Linux for CRIS (ETRAX 100).
   Copyright (C) 2000, 2001 Axis Communications.  */

#include "linunistd.h"

/* From asm-etrax100/mman.h: beware of updates.  */
#define PROT_READ	0x1		/* page can be read */
#define PROT_WRITE	0x2		/* page can be written */
#define MAP_ANONYMOUS	0x20		/* don't use a file */

char *
_sbrk (int d)
{
  static long last_alloc = NULL;

  /* FIXME: Things are a whole lot different than elinux.  */
#ifndef __ELF__

  /* We can't promise linear memory from a predetermined location.
     We're NO_MM.  We're paria.  We have to rely on tweaks and unclean
     behavior.  We abuse the fact that the malloc function in newlib
     accepts nonlinear chunks in return to its sbrk calls (with a minor
     patch).  */

  /* We use an "old" type mmap, which takes a pointer to a vector of 6
     longs where the parameters are stored.  */
  long buffer[6];

  /* We can't return memory.  Well we could, but we would have to keep a
     list of previous allocations.  FIXME:  Seems reasonable to do that
     later.  */
  if (d < 0)
    return (char *) last_alloc;

  buffer[3] = MAP_ANONYMOUS;    /* Not associated with a file.  */
  buffer[4] = -1;               /* No file.  */
  buffer[0] = 0;                /* Address 0: let mmap pick one.  */
  buffer[1] = d;                /* Length.  */
  buffer[2] = (PROT_READ | PROT_WRITE); /* Protection flags.  */
  buffer[5] = 0;                /* Offset into file.  */

  last_alloc = _Sys_mmap (buffer);

  return (char *) last_alloc;
#else

  long prev_brk;

  if (last_alloc == 0)
  {
    last_alloc = _Sys_brk (0);

    if (last_alloc < 0)
      return (char *) -1;
  }

  prev_brk = last_alloc;

  if (_Sys_brk (last_alloc + d) < last_alloc + d)
    return (char *) -1;

  last_alloc += d;

  return (char *) prev_brk;
#endif
}

link_warning(_sbrk, "New and untested library function")
