/* Registration of .fini code with atexit for CRIS.
   Contributed by Axis Communications.
   Written by Hans-Peter Nilsson <hp@axis.se>

   Copyright (C) 2000 Free Software Foundation, Inc.

This file is part of GNU CC.

GNU CC is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2, or (at your option) any
later version.

In addition to the permissions in the GNU General Public License, the
Free Software Foundation gives you unlimited permission to link the
compiled version of this file with other programs, and to distribute
those programs without any restriction coming from the use of this
file.  (The General Public License restrictions do apply in other
respects; for example, they cover modification of the file, and
distribution when not linked into another program.)

This file is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.

   As a special exception, if you link this library with files, some of
   which are compiled with GCC, this library does not by itself cause
   the resulting object or executable to be covered by the GNU General
   Public License.
   This exception does not however invalidate any other reasons why
   the executable file or object might be covered by the GNU General
   Public License.  */

#include "config.h"
#include "tsystem.h"

#ifdef __ELF__

asm (INIT_SECTION_ASM_OP);
asm ("jsr ___perhaps_register_fini");
asm (TEXT_SECTION_ASM_OP);

/* For the moment, we always pull in this function.  FIXME: A way to
   weaken it if the .fini section is empty would be nice.  */
extern int atexit (void (*)(void));

extern void __do_global_ctors (void) __attribute__ ((__weak__));
extern void __fini__start (void) __attribute__ ((__weak__));
extern void __init__start (void) __attribute__ ((__weak__));

static void
__perhaps_register_fini (void) __attribute ((__unused__));

static void
__perhaps_register_fini (void)
{
  /* Register the finalizers with atexit if there are any.

     People must call either __do_global_ctors or __init__start,
     or (for ELF) do _init () and atexit (&_fini).

     If doing _init () and atexit (&_fini), then this file must be
     omitted, or a linker script that does not set __init_start must be
     used.

     If there's a __do_global_ctors which is *not* the one the linker
     provide as an alias for _init and __init__start, then we assume
     that it takes care of registering the .fini section with atexit.  */

  if (__init__start != 0
      && (__do_global_ctors == 0 || __init__start == __do_global_ctors))
    atexit (__fini__start);
}

#else /* ! __ELF__ */

/* A compilation unit must not be empty.  */
extern int _Dummy_var;

#endif /* __ELF__ */

/*
 * Local variables:
 * eval: (c-set-style "gnu")
 * indent-tabs-mode: t
 * End:
 */
