/* Low-level file support for simulator.
   Copyright (C) 1998, 1999, 2000 Axis Communications.  */

#include <stdio.h>
#include "simcodes.h"
#include <errno.h>
#undef errno
extern int errno;

size_t
_write (unsigned int file, const void *ptr, size_t len)
{
  static struct _Partype par = {0};

  int ret, i;

  par.p1 = (void *) ptr;

  if (len == 0)
    return 0;

  if (file >= 32)
    {
      errno = EBADF;
      return -1;
    }

  par.voidp = _Sim_file_cookies[file];

  par.i = len;

  __asm__("bmod [%1],%0" : "=r" (ret) : "r" (S_fwrite) , "0" (&par));

  if (ret) 
    errno = ret;

  return par.i;
}
