/* Low-level memory support for simulator.
   Copyright (C) 1998, 1999, 2000 Axis Communications.  */

#include <stddef.h>
#include <errno.h>
#include "simcodes.h"
#undef errno
extern int errno;

char *
_sbrk(int d)
{
  static char *nowtop = NULL;
  static char *maxtop = NULL;
  static char *low = NULL;
  static struct _Partype par;
  int rounded_d;
  char *lasttop = nowtop;
  char *p;

  /* The simulator does not support giving back memory, so we just
     decrease the top-of-memory.  */
  if (d < 0)
    {
      if (nowtop + d > low)
	nowtop += d;
      else
	/* Giving back more than got.  Error.  */
        SIM_EXIT (-43);

      return lasttop;
    }
  else if (nowtop < maxtop)
    {
      if (nowtop + d <= maxtop)
	{
	  nowtop += d;
	  return lasttop;
	}
      else
        {
          /* Decrease the request by the slack we already have.  This
             causes d to count from maxtop rather than nowtop (lasttop).  */
          d -= maxtop - nowtop;
          nowtop = maxtop;
        }
    }

  /* If we're going to allocate, round off the size to a cache-line
     size, since the simulator will do that.  Keep requests aligned.  */
  rounded_d = (d + 31) & ~31;

  par.i = rounded_d;

  __asm__ ("bmod [%1],%0" : "=r" (p) : "r" (S_sbrk) , "0" (&par));

  if (p == (char *) -1) 
    {
      nowtop = lasttop;
      errno = ENOMEM;
      return (char *) -1;
    }

  if (low == NULL)
    {
      low = p;
      lasttop = p;
      nowtop = p;
      maxtop = p;
    }

  /* After the first time, we use the previous mark, not what the
     simulator gave us.  This because we might have had giveback sbrk
     calls, in which case we will ask the simulator for the balance when
     a new, record-setting request comes in.  The drawback is that bugs
     might cause us to be out of sync with what is returned by the
     simulator, so trap differences.  */
  if (p != maxtop)
    /* FIXME: What exit code is suitable here?  It will be returned
       by the simulator.  */
    SIM_EXIT (-42);

  nowtop += d;
  maxtop += rounded_d;

  return lasttop;
}

