/* Low-level file support for simulator.
   Copyright (C) 1998, 1999, 2000 Axis Communications.  */

#include <stdio.h>
#include "simcodes.h"
#include <errno.h>
#undef errno
extern int errno;

size_t
_read(unsigned int file, void *ptr, size_t nbyt)
{
  static struct _Partype par = {0};
  int ret;

  if (file >= 32)
    {
      errno = EBADF;
      return 0;
    }

  par.i  = nbyt;
  par.p1 = ptr;
  par.voidp = _Sim_file_cookies[file];

  __asm__("bmod [%1],%0" : "=r" (ret) : "r" (S_fread) , "0" (&par));

  if (ret) 
    errno = ret;

  return par.i;
}
