/* Low-level file support for simulator.
   Copyright (C) 1998, 1999, 2000 Axis Communications.  */

#include <sys/fcntl.h>
#include "simcodes.h"
#include <errno.h>
#include <stdarg.h>
#undef errno
extern int errno;

int
_open (const char *fnam, int flags, ...)
{
  static struct _Partype par = {0};
  const char *mods;
  int i;
  void *cookie;
  int mode;

  /* We map this to a fopen call.  Sorry.  The mode parameter is ignored.
     The flags parameter is stymied.  */
  flags &= (O_RDONLY | O_WRONLY | O_RDWR | O_CREAT | O_APPEND | O_TRUNC);

  /* FIXME: This mapping is just based on observation of failure in
     libio filebuf::open and newlib __sflags, trying to remedy problems
     exposed in the testsuite.  FIXME: Some might still be around...  */
  if ((flags & O_ACCMODE) == O_RDONLY)
    mods = "r";
  else if ((flags & (O_WRONLY | O_APPEND)) == (O_WRONLY | O_APPEND))
    mods = "a";
  else if ((flags & (O_RDWR | O_APPEND)) == (O_RDWR | O_APPEND))
    mods = "a+";
  else if ((flags & (O_WRONLY | O_CREAT)) == (O_WRONLY | O_CREAT)
	   || (flags & (O_WRONLY | O_TRUNC)) == (O_WRONLY | O_TRUNC))
    mods = "w";
  else if ((flags & (O_RDWR | O_CREAT)) == (O_RDWR | O_CREAT))
    mods = "w+";
  else if (flags & O_RDWR)
    mods = "r+";
  else
    {
      errno = EINVAL;
      return -1;
    }

  /* Find an empty slot.  */
  for (i = 0; i < 32; i++)
    if (_Sim_file_cookies[i] == NULL)
      break;

  if (i == 32)
    {
      errno = ENFILE;
      return -1;
    }

  par.s1 = (char *) fnam;
  par.s2 = (char *) mods;
  par.voidp = NULL;

  __asm__ ("bmod [%1],%0" : "=r" (cookie) : "r" (S_freopen) , "0" (&par));

  if (par.i)
    errno = par.i;

  if (cookie == NULL)
    return -1;

  _Sim_file_cookies[i] = cookie;

  return i;
}
