/* C base for the startuproutine to be located at addr 0.
 
    This really shouldnt be used on a real embedded system.
    It is more for use when you do new hardware, and want a quick fix
    to run your main() loop for a test program.

    Please write your own since this doesn't take hardware
    considerations in account. 

*/
#include <stdio.h>

/* The environment pointer.  Also the seldom-used third argument to
   main().  */
char **environ;

/* Argument 2 to main(). */
char **_Argv;

/* Argument 1 to main(). */
int _Argc;

/* No name ambiguities in this file, so keep asms without register
   prefixes.  */
asm (".syntax no_register_prefix");

void _start0(void);

/* If you write an interrupt routine, there must be a corresponding 
   "const char _Do_interrupt = TRUE;" in your interrupt-routine, or
   there will be linked in a default "const char _Do_interrupt = FALSE;"
   from the libraries. */
extern const char _Do_interrupt;

void start(void)
#ifdef __ELF__
     __attribute__ ((__section__ (".startup")))
#endif
     ;

/* This is located at address 0. */
void start(void)
{
  __asm__ volatile(".word 39");	/* Configuration word, magic for rsim. */
  __asm__ volatile (".globl __start");
  __asm__ volatile ("__start: ba __stackload");	/* Skip interrupt vectors. */
  __asm__ volatile ("nop
Here_is_int2_vector:");
  /* Only vectors 2..255 are useful for IRQ. */
  /* In this interrupt code, the vectors all point to the same code,
     which must determine the priority order, and find out which
     interrupts were issued.  */
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");

/* End of IRQ vectors */

  __asm__ volatile("__stackload:");
  /* Assume 128k ram here, usable as stack.  */
  __asm__ volatile("  move.d 0x40020000,sp");
  __asm__ volatile (" jsr __start0");

  /* We shouldn't return from that.  However, report failure as far as
     possible (although it will be ignored in _exit() below).  */
  __asm__ volatile (" moveq -1,r10");
  __asm__ volatile (" jsr __exit");
}

/* This is a template on how to write a dummy-wrapper for an interrupt
   routine (the address the vectors point at). */
void _Dummy_int(void)
{
  /* The "_INTERRUPT" symbol is for "simfix" so we can easily see when 
     there is an interrupt. */
  __asm__ volatile ("
        .global _INTERRUPT
int2:
	push irp ; Really only needed if you expect nested interrupts
_INTERRUPT:
        push ccr ; Must be done
        push srp ; Only needed if you want to call subroutines. Who doesnt?
        di       ; Must be done, else you will end up out of stack...
        subq 14*4,sp ; Allocate stack to save registers
        movem r13,[sp] ; Well, you normally (from C) only need save r9..r13
        move.d _intr_routine_ptr,r0
        jsr     [r0]
        movem [sp+],r13 ; Restore registers
        ei       ; Re-enable interrupts (not needed - pop ccr below)
        pop srp  ; Restore any return address for the interrupted routine
        pop ccr  ; Restore flags
        jump [sp+]");		/* Return to the interrupted */
}

/* This is the end of everything.  */
void
_exit (int exval)
{
  /* This maybe could be done more gracefully.
     It is the entry from "call" to abort(). */
  __asm__ volatile
    ("
; Let simulators exit on opcode 0 (bcc .+2)
	clearf c
        bcc .+2
        nop
; If that didn't help, loop until next week's episode.
__Forever: ba __Forever
	nop");
}

extern char _Sdata[], _Edata[], _Etext[], _Ebss[], _Sbss[];

extern void __init__start (void) __attribute ((weak));
extern void __aout__ctors (void) __attribute ((weak));

/* This function is where we jump just before main(). */
void _start0(void)
{
  int exitval;

  /* Don't trust that weak attribute.  */
  __asm__ volatile (".weak ___init__start");
  __asm__ volatile (".weak ___aout__ctors");

  if (_Sdata != _Etext)
  {
    memcpy (_Sdata, _Etext, _Edata - _Sdata);
  }

  memset (_Sbss, 0, _Ebss - _Sbss);

  if (__init__start)
    __init__start ();

  if (__aout__ctors)
    __aout__ctors ();

  /* If we havent linked in any interrupt routine, then dont do interrupts.
     the interrupt_routine() and _Do_interrupt = 0 dummys are in int.c */
  if (_Do_interrupt)
    __asm__ volatile ("ei");

  /* Do the real stuff. */
  exitval = main(_Argc, _Argv, environ);

  /* If main returns (not through exit ()), we call back for an "exit ()",
     which eventually calls _exit () above which gets to the label below;
     bit twisty.  FIXME: untwist.  */
  exit (exitval);

  /* Don't put anything here, gcc will optimize it out as unreachable.  */
}
