/* Definitions for GCC.  Part of the machine description for CRIS.
   Copyright (C) 1998, 1999, 2000, 2001 Free Software Foundation, Inc.
   Contributed by Axis Communications.

This file is part of GNU CC.

GNU CC is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU CC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU CC; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

/* Prototypes for the CRIS port.  */

#if defined(FILE) || defined(stdin) || defined(stdout) || defined(getc) || defined(putc)
#define STDIO_INCLUDED
#endif

extern void cris_conditional_register_usage PARAMS ((void));
extern int cris_simple_epilogue PARAMS ((void));
#ifdef RTX_CODE
extern int cris_general_operand_or_symbol PARAMS ((rtx, enum machine_mode));
extern int cris_general_operand_or_gotless_symbol
  PARAMS ((rtx, enum machine_mode));
extern int cris_orthogonal_operator PARAMS ((rtx, enum machine_mode));
extern int cris_commutative_orth_op PARAMS ((rtx, enum machine_mode));
extern int cris_extend_operator PARAMS ((rtx, enum machine_mode));
extern int cris_operand_extend_operator PARAMS ((rtx, enum machine_mode));
extern int cris_plus_or_bound_operator PARAMS ((rtx, enum machine_mode));
extern int cris_bdap_operand PARAMS ((rtx, enum machine_mode));
extern int cris_bdap_biap_operand PARAMS ((rtx, enum machine_mode));
extern int cris_const_ref_operand PARAMS ((rtx, enum machine_mode));
extern int cris_mem_call_operand PARAMS ((rtx, enum machine_mode));
extern int cris_general_operand_or_plt_symbol PARAMS ((rtx, enum machine_mode));
extern const char *cris_op_str PARAMS ((rtx));
extern int cris_eligible_for_epilogue_delay PARAMS ((rtx));
extern void cris_notice_update_cc PARAMS ((rtx, rtx));
extern int cris_address_cost PARAMS ((rtx));
extern void cris_print_operand PARAMS ((FILE *, rtx, int));
extern void cris_print_operand_address PARAMS ((FILE *, rtx));
extern int cris_side_effect_mode_ok PARAMS ((enum rtx_code, rtx *, int, int,
                                             int, int, int));
extern rtx cris_return_addr_rtx PARAMS ((int, rtx));
extern int cris_legitimate_pic_operand PARAMS ((rtx));
extern int cris_gotless_symbol PARAMS ((rtx));
extern int cris_got_symbol PARAMS ((rtx));
extern int cris_symbol PARAMS ((rtx));
extern void cris_output_addr_const PARAMS ((FILE *, rtx));
extern int cris_cfun_uses_pic_table PARAMS ((void));

# ifdef TREE_CODE
extern rtx cris_expand_builtin_va_arg PARAMS ((tree, tree));
extern void cris_encode_section_info PARAMS ((tree));
# endif
#endif /* RTX_CODE */

#ifdef STDIO_INCLUDED
/* Output all deferred strings.  */
extern void cris_output_deferred_strings PARAMS ((FILE *));

/* Prepare for string deferring.  */
extern void cris_init_deferred_strings PARAMS ((void));

extern void cris_asm_output_constructor PARAMS ((FILE *, const char *));
extern void cris_asm_output_destructor PARAMS ((FILE *, const char *));
extern void cris_output_cdtors PARAMS ((FILE *));

extern void cris_function_prologue PARAMS ((FILE *, int));
extern void cris_function_epilogue PARAMS ((FILE *, int));

# ifdef TREE_CODE
extern void cris_asm_output_mi_thunk PARAMS ((FILE *, tree, int, tree));
extern void cris_asm_output_section_name PARAMS ((FILE *, tree, const char *,
						  int));
# endif
#endif

/* Add a local-string-label and possibly a string to "the list", marking
   whether to surely output it (say that it is referenced).  */
extern int cris_deferred_string_added PARAMS ((int, char *, int, int, int));

/* Need one that returns an int; usable in expressions. */
extern int cris_fatal PARAMS ((char *));

extern void cris_override_options PARAMS ((void));

extern int cris_initial_elimination_offset PARAMS ((int, int));

extern void cris_init_expanders PARAMS ((void));

extern int cris_delay_slots_for_epilogue PARAMS ((void));

extern char *cris_strip_name_encoding PARAMS ((const char *));
