/* Classic __CTOR_LIST__[] and __DTOR_LIST__[] handling for CRIS.
   Contributed by Axis Communications.
   Written by Hans-Peter Nilsson <hp@axis.se>

   Copyright (C) 2000, 2001 Free Software Foundation, Inc.

This file is part of GNU CC.

GNU CC is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2, or (at your option) any
later version.

In addition to the permissions in the GNU General Public License, the
Free Software Foundation gives you unlimited permission to link the
compiled version of this file with other programs, and to distribute
those programs without any restriction coming from the use of this
file.  (The General Public License restrictions do apply in other
respects; for example, they cover modification of the file, and
distribution when not linked into another program.)

This file is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.

   As a special exception, if you link this library with files, some of
   which are compiled with GCC, this library does not by itself cause
   the resulting object or executable to be covered by the GNU General
   Public License.
   This exception does not however invalidate any other reasons why
   the executable file or object might be covered by the GNU General
   Public License.  */

/* We don't use this on Linux.  We might be using it on ELF if we ever
   link together a.out and ELF objects, so don't key off on __ELF__.  For
   Linux, it matters: it is important to not emit __CTOR_LIST__ and
   __DTOR_LIST__ references since we create a shared object.  */
#ifndef __linux__

#include "config.h"
#include "tsystem.h"
#include "gbl-ctors.h"

/* This is primarily a kludge since we cannot compile-in the __main code
   from libgcc2.c while (sometimes) having an .init section.
   Things might change and this file might go away.  Until then, this file
   is a way of not complicating main files for one target only.  We have
   copies of the L__main code here with unimportant differences.  */

/* Run all the global destructors on exit from the program.  */

void
__do_global_dtors (void)
{
  static func_ptr *p = __DTOR_LIST__ + 1;
  while (*p)
    {
      p++;
      (*(p-1)) ();
    }
}

extern void __fini__start (void) __attribute__ ((__weak__));

void
__do_global_ctors (void)
{
  /* Support recursive calls: run initializers just once.  */
  static int initialized;

  if (initialized)
    return;

  initialized = 1;

  /* As a precaution, we do not register the .fini section if
     __fini__start is somehow set to point to __do_global_dtors
     (which is defined above).  */
  if (__fini__start && __fini__start != __do_global_dtors)
    atexit (__fini__start);

  DO_GLOBAL_CTORS_BODY;
  atexit (__do_global_dtors);
}

/* The collect2-generated file refers to us by this unique name.  */
void
__aout__ctors (void) __attribute__ ((__alias__ ("__do_global_ctors")));

#endif /* not __linux__ */

/*
 * Local variables:
 * eval: (c-set-style "gnu")
 * indent-tabs-mode: t
 * End:
 */
