/* Support for NO_MM Linux for CRIS (ETRAX 100).
   Copyright (C) 2000 Axis Communications.  */

#include "linunistd.h"

/* These bits are ripped from asm-etrax100/termbits.h: beware of
   updates.  */
typedef unsigned int tcflag_t;
typedef unsigned char cc_t;
#define NCCS 19

struct termios {
	tcflag_t c_iflag;		/* input mode flags */
	tcflag_t c_oflag;		/* output mode flags */
	tcflag_t c_cflag;		/* control mode flags */
	tcflag_t c_lflag;		/* local mode flags */
	cc_t c_line;			/* line discipline */
	cc_t c_cc[NCCS];		/* control characters */
};

/* From asm-etrax100/ioctls.h: beware of updates.  */
#define TCGETS          0x5401

/* Note that this name does not have a prepended underscore.  */
int
isatty (int fd)
{
  struct termios dummy;
  int save_errno = errno;

  int ret = _Sys_ioctl (fd, TCGETS, (unsigned long) &dummy);

  errno = save_errno;

  return ret == 0;
}

link_warning(_isatty, "New and untested library function")
