/* Support for NO_MM Linux for CRIS (ETRAX 100).
   Copyright (C) 2000, 2003 Axis Communications.  */

#include <sys/stat.h>
#include "linunistd.h"

int
_fstat (int fd, struct stat *buf)
{
  struct new_stat ks;
  int retval = _Sys_fstat (fd, &ks);

  /* Blank before filling it in.  */
  memset (buf, 0, sizeof (*buf));

  /* We have to translate from the linux struct new_stat.
     It seems we don't have to translate the contents, though.  */
  buf->st_dev = ks.st_dev;
  buf->st_ino = ks.st_ino;
  buf->st_mode = ks.st_mode;
  buf->st_nlink = ks.st_nlink;
  buf->st_uid = ks.st_uid;
  buf->st_gid = ks.st_gid;
  buf->st_rdev = ks.st_rdev;
  buf->st_size = ks.st_size;
  buf->st_blksize = ks.st_blksize;
  buf->st_blocks = ks.st_blocks;
  buf->st_atime = ks.st_atime;
  buf->st_mtime = ks.st_mtime;
  buf->st_ctime = ks.st_ctime;

  return retval;
}
