/* Call ctors and dtors from shared libraries, if any.
   Copyright (C) 1999, 2000 Axis Communications.  */

typedef void (*vfnp) (void);

vfnp * const _Ctors asm(".$global.lib.ctors") = {0};
vfnp * const _Dtors asm(".$global.lib.dtors") = {0};

/* We better provide weak empty ctor and dtor lists, since they are not
   created if the main program does not have ctor/dtors.
   FIXME: Is that comment correct?  What about a program without
   ctors/dtors, but using a library with ctors/dtors?  */

static vfnp const defaultors[] = {0, 0};

extern vfnp * __CTOR_LIST__ __attribute__ ((weak, alias ("defaultors")));
extern vfnp * __DTOR_LIST__ __attribute__ ((weak, alias ("defaultors")));

void
_Libctors (void)
{
  const vfnp *firstor = _Ctors;
  const vfnp *ctors;

  /* Have to find the last ctor; they will run in opposite order as in
     the table. */
  if (firstor != 0 && *firstor != 0)
  {
    for (ctors = firstor; *ctors != 0; ctors++)
      ;

    while (--ctors != firstor)
    {
      (**ctors)();
    }

    (**ctors)();
  }
}

void _Libdtors(void)
{
  const vfnp *dtors = _Dtors;

  if (dtors)
    while (*dtors != 0)
    {
      (**dtors++) ();
    }
}
