/* Low-level file support for simulator.
   Copyright (C) 1998, 1999, 2000 Axis Communications.  */

#include <stdio.h>
#include "simcodes.h"
#include <errno.h>
#undef errno
extern int errno;

int
_close (unsigned int file)
{
  int out, code=0;

  static struct _Partype par = {0};

  if (file >= 32)
    {
      errno = EBADF;
      return -1;
    }

  par.voidp = _Sim_file_cookies[file];

  __asm__ ("bmod [%1],%0" : "=r" (out) : "r" (S_fclose) , "0" (&par));

  _Sim_file_cookies[file] = NULL;

  if (out)
    {
      errno = out;
      code = EOF;
    }

  return code;
}
