/* Support for Linux for CRIS (ETRAX 100, ETRAX 100 LX).
   Copyright (C) 2000, 2001, 2002, 2003 Axis Communications.  */

#include "linunistd.h"

__asm__ (".syntax no_register_prefix");

#ifdef __ELF__
/* This simulator magic is supposed to be found two bytes before _start.
   Trying to do this with an ordinary const char[] and attribute section
   makes gcc barf; it doesn't like having the same section attribute for
   both code and data.  */
__asm__ ("\
 .section .startup,\"ax\",@progbits\n\
 .byte 55,55\n\
 .previous");
#endif

/* Argument 2 to main(). */
char **_Argv;

/* Argument 1 to main(). */
int _Argc;

/* Remembering the sp we got upon entry - not really necessary I think.  */
static long _System_stack;

/* Store the kernel adress of system_call.  */
static long _System_call_ptr;

/* For debugging. */
typedef void (*cpf)(char *buf);
cpf console_print_etrax;

/* The environment pointer; also the seldom-used third argument to
   main().  */
char **environ;

/* Note that _start is not in a special section here, as opposed to the
   non-linux variants.  */

/* N.B.: It is important that this be the first function.
   This file is the first thing in the text section.
   The symbol __start is the symbol used to set the entry address for
   ELF files.  */
void
_start (void)
#ifdef __ELF__
 __attribute ((__section__ (".startup")));
void
_start (void)
#endif
{
#ifdef __AOUT__
  __asm__ volatile ("jump __start0");
  __asm__ volatile (".word 0");  /* Filler to eight bytes. */
#else
  __asm__ volatile ("move.d __start0,r13\n\tjump r13\n\tsetf");
#endif

  /* This symbol may be set at link-time.  Note that it always has two
     underscores.  */
  __asm__ volatile (".dword __Stacksize");
  __asm__ volatile (".weak __Stacksize");

  /* Maybe more magic stuff provided by the program (or linker) */


  /** All this is incoming:

   * Reasonable stack for sp in r2

   * Argument counter to r3

   * Argument vector to r4

   * Environment to r5

   * system_call in r6 ?? May change

   * DATA in r7 ??? May change

   * BSS in r8 (wiped) ??? May change

   Remember to check the assembler output so it has not clobbered
   crucial registers, or anything.

   */
  /* These registers MUST not have been clobbered between _start and here. */

  /* Do not assume anything about which registers are saved or how
     parameters are passed.  Do any necessary things here, then jump to
     _start1 and let it set up parameters for main.  */
  __asm__ volatile("\n__start0:");
  /* We currently do not use r7 and r8; executables contain relocs.  */
  __asm__ volatile("move.d " __SYMBOL_PREFIX "_System_stack,r13");
  __asm__ volatile("move.d sp,[r13]");
#ifdef __AOUT__
  /* Implying elinux startup.  */
  __asm__ volatile("move.d r2,sp"); 
#else
  /* Find ARGC, ARGV and ENV.  */

  /* ARGC.  */
  __asm__ volatile("move.d [sp],r3"); 

  /* ARGV.  */
  __asm__ volatile("move.d sp,r4"); 
  __asm__ volatile("addq 4,r4"); 

  /* ENVP.  */
  __asm__ volatile("move.d sp,r5"); 
  __asm__ volatile("addi r3.d,r5"); 
  __asm__ volatile("addq 8,r5"); 

  /* Terminate R9 and R6; we don't have a "console_print_etrax" or system
     call function.  */
  __asm__ volatile("clear.d r9"); 
  __asm__ volatile("clear.d r6"); 
#endif
  __asm__ volatile("move.d " __SYMBOL_PREFIX "_System_call_ptr,r13\n\tmove.d r6,[r13]");
  __asm__ volatile("move.d " __SYMBOL_PREFIX "_Argc,r13\n\tmove.d r3,[r13]"); 
  __asm__ volatile("move.d " __SYMBOL_PREFIX "_Argv,r13\n\tmove.d r4,[r13]");
  __asm__ volatile("move.d " __SYMBOL_PREFIX "environ,r13\n\tmove.d r5,[r13]");
  __asm__ volatile("move.d " __SYMBOL_PREFIX "console_print_etrax,r13\n\tmove.d r9,[r13]");
  __asm__ volatile("move.d " __SYMBOL_PREFIX "start1,r13\n\tjump r13\n\tsetf");

#ifdef __AOUT__
  /* Note that this system call interface is only used for statically
     linked binaries.  The dynamic loader will change all other
     references to .$System.call into the kernel entry address.

     If dynamically linked objects were to use *this* entry, they would
     all have a dependency to the main program and not be shareable.  */
  __asm__ volatile(".weak .$System.call \n\
.$System.call:\n\
	jump [" __SYMBOL_PREFIX "_System_call_ptr]");
#endif
}

extern void _Libctors(void);
extern void _Libdtors(void);

extern void __init__start (void) __attribute ((weak));
extern void __aout__ctors (void) __attribute ((weak));

static void
start1 ()
{
#ifdef __ELF__
  /* For ELF systems, we call _init and register _fini with atexit.  */
  {
    extern void _init (void);
    extern void _fini (void);
    _init ();
    if (atexit (_fini) != 0)
      exit (-1);
  }
#else
  /* Don't trust that weak attribute.  */
  __asm__ volatile (".weak ___init__start");
  __asm__ volatile (".weak ___aout__ctors");

  /* Constructors which may get here through the ELF .init section, when
     linking ELF and producing a.out.  */
  if (__init__start)
    __init__start ();

  if (__aout__ctors)
    __aout__ctors ();

  /* Call constructors in shared libraries. */
  _Libctors ();

  if (atexit (_Libdtors) != 0)
    exit (-1);
#endif

  /* Call the user program.  */
  exit (main (_Argc, _Argv, environ));
}

