/* Copyright (C) 1992, 93, 95, 96, 99, 00 Free Software Foundation, Inc.
This file is part of the GNU C Library.
Contributed by Ulrich Drepper, <drepper@gnu.ai.mit.edu>, August 1995.

The GNU C Library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

The GNU C Library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with the GNU C Library; see the file COPYING.LIB.  If
not, write to the Free Software Foundation, Inc., 675 Mass Ave,
Cambridge, MA 02139, USA.  */

#ifndef _LINUX_ETRAX_SYSDEP_H
#define _LINUX_ETRAX_SYSDEP_H 1

/* Etrax specific sysdep files are in sysdeps/etrax/sysdep.h (non-Linux stuff)
   and here (linux stuff).
*/

#include <sysdeps/unix/sysdep.h>
#include <sysdeps/etrax/sysdep.h>

/* For Linux we can use the system call table in the header file
	/usr/include/asm/unistd.h
   of the kernel.  But these symbols do not follow the SYS_* syntax
   so we have to redefine the `SYS_ify' macro here.  */
#undef SYS_ify
#define SYS_ify(syscall_name)	__NR_##syscall_name

/* Linux uses a negative return value to indicate syscall errors,
   unlike most Unices, which use the condition codes' carry flag.

   Since version 2.1 the return value of a system call might be
   negative even if the call succeeded.  E.g., the `lseek' system call
   might return a large offset.  Therefore we must not anymore test
   for < 0, but test for a real error by making sure the value in %eax
   is a real error number.  Linus said he will make sure the no syscall
   returns a value in -1 .. -4095 as a valid result so we can savely
   test with -4095.  */

#define __STR(x) #x
#define STR(x) __STR(x)

/* Remember that our elinux ABI says R10-R13 contains the first 4 arguments just
   like the CRIS ABI. However we want the 5'th argument in R0 while CRIS ABI puts it
   on the stack. Therefore, the move.d [sp+8],r0 below. For syscalls that don't use it
   it doesn't matter of course. NOTE we COULD use the args argument to PSEUDO as a way
   to only instantiate the r0 stuff if args == 5! I don't know how hard it is.
*/

#undef	PSEUDO
#define	PSEUDO(name, syscall_name, args) \
          extern void name(void); \
	  __asm__ (".text\n\t" \
		   ".globl " STR(C_SYMBOL_NAME(name)) "\n" \
		   STR(C_LABEL(name)) "\n\t" \
		   "push " __REG_PREFIX "r1\n\t" \
		   "push " __REG_PREFIX "r0\n\t" \
		   "movu.w " STR(__NR_##syscall_name) \
		   "," __REG_PREFIX "r1\n\t" \
		   "move.d [" __REG_PREFIX "sp+8]," __REG_PREFIX "r0\n\t" \
		   STR(CRIS_SYSCALL) "\n\t" \
		   "pop " __REG_PREFIX "r0\n\t" \
		   "pop " __REG_PREFIX "r1\n\t" \
		   "cmp.d -4095," __REG_PREFIX "r10\n\t" \
		   "bcs 1f\n\t" \
		   "nop\n\t" \
		   "jump " STR(C_SYMBOL_NAME(__syscall_error)) "\n" \
		   "1:\n\t");

#undef	PSEUDO_END
#define	PSEUDO_END(name)

/* On newer kernels, we use "break 13".  Do this for ELF only, for now,
   so people can use their old kernels.  */
#ifdef __ELF__
#define CRIS_SYSCALL break 13
#else
#define CRIS_SYSCALL jir .$System.call
#endif

#ifdef  ASSEMBLER

#undef	END
#define END(name)							      \
  ASM_SIZE_DIRECTIVE(name)

#define SYSCALL_ERROR_HANDLER	/* Nothing here; code in sysdep.S is used.  */

#endif	/* ASSEMBLER */

#endif /* linux/etrax/sysdep.h */
