/* Copyright (C) 1995, 1996, 1997, 1999, 2000 Free Software Foundation, Inc.
   This file is part of the GNU C Library.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

#include <sysdep.h>

/* make space for the errno variable */

	.data
	.globl C_SYMBOL_NAME(errno)
	.type C_SYMBOL_NAME(errno),@object
	.size C_SYMBOL_NAME(errno),4
C_LABEL(errno)
	.zero 4
	.globl C_SYMBOL_NAME(_errno)
	.type C_SYMBOL_NAME(_errno),@object
	/* This name is expected by hj's libc.so.5 startup code.  */
C_SYMBOL_NAME(_errno) = C_SYMBOL_NAME(errno)
	.text

/* The following code is only used in the shared library when we
   compile the reentrant version.  Otherwise each system call defines
   each own version.  */

#ifndef PIC

/* The syscall stubs jump here when they detect an error.
   The code for Linux is almost identical to the canonical Unix/i386
   code, except that the error number in %eax is negated.  */

#undef CALL_MCOUNT
#define CALL_MCOUNT /* Don't insert the profiling call, it clobbers %eax.  */

#define _ERRNO_H
#include <errnos.h>

	.globl C_SYMBOL_NAME(__syscall_error)
C_LABEL(__syscall_error)
			
	neg.d __PREFIX_REG(r10),__PREFIX_REG(r10)

#if defined (EWOULDBLOCK_sys) && EWOULDBLOCK_sys != EAGAIN
	/* We translate the system's EWOULDBLOCK error into EAGAIN.
	   The GNU C library always defines EWOULDBLOCK==EAGAIN.
	   EWOULDBLOCK_sys is the original number.  */
	/* Is it the old EWOULDBLOCK?  */
	cmpu.w EWOULDBLOCK_sys, __PREFIX_REG(r10)
	bne notb		/* Branch if not.  */
	nop
	/* Yes, translate it to EAGAIN.  */
	movu.w EAGAIN, __PREFIX_REG(r10)
notb:
#endif
	move.d __PREFIX_REG(r10), [C_SYMBOL_NAME(errno)]

#ifdef	_LIBC_REENTRANT
	push __PREFIX_REG(r10)
        push __PREFIX_REG(srp)
	jsr C_SYMBOL_NAME(__errno_location)
        pop __PREFIX_REG(srp)
	pop __PREFIX_REG(r11)
	move.d __PREFIX_REG(r11),[__PREFIX_REG(r10)]
#endif
	moveq -1, __PREFIX_REG(r10)
	ret
	nop

END (__syscall_error)

#endif	/* !PIC */
