/* $Id: start.c,v 1.10 2000/12/21 13:14:50 hp Exp $ */

/* C base for the crt0 for uClinux on etrax 100 (will not run on
 earlier etraxes. */

#include <errno.h>
#include <stdlib.h>
#include <unistd.h>
#include <sysdep.h>		/* In case it wants to define anything.  */

#undef DEBUG

/* The first piece of initialized data.  */
int __data_start = 0;
#ifdef HAVE_WEAK_SYMBOLS
weak_alias (__data_start, data_start)
#endif

#ifndef errno
volatile int __errno;
string_alias (__errno, errno)
#endif

extern void __libc_init __P ((int argc, char **argv, char **envp));
extern int main __P ((int argc, char **argv, char **envp));

/* Argument 2 to main(). */
char **_Argv;

/* Argument 1 to main(). */
int _Argc;

int __libc_enable_secure = 0; /* set by some dl code normally.. */
int _dl_starting_up = 0;

/* remembering the sp we got upon entry - not really necessary I think */
static long _System_stack;

/* storing the kernel adress of system_call */
static long _System_call_ptr;

/* for libc debugging */
typedef void (*bozo)(char *buf);
bozo console_print_etrax;

/* N.B.: It is important that this be the first function.
   This file is the first thing in the text section.  */
void
_start ()
{
  __asm__ volatile ("jump __start0");	/* Skip interrupt vectors. */
  __asm__ volatile (".word 0"); /* Filler to eight bytes. */
  /* May be specified at linking.  Note that it always have "__".  */
  __asm__ volatile (".dword __Stacksize");
  __asm__ volatile (".weak __Stacksize");

  /* Maybe more magic stuff provided by the program (or linker) */


  /** All this is incoming:

   * Reasonable stack for sp in r2

   * Argument counter to r3

   * Argument vector to r4

   * Environment to r5

   * system_call in r6 ?? May change

   * DATA in r7 ??? May change

   * BSS in r8 (wiped) ??? May change

   Remember to check the assembler output so it has not clobbered
    crucial registers, or ANYTHING.

   */
  /* These registers MUST not have been clobbered between _start and here. */

  /* When testing different calling conventions, it is very important not to
     assume anything about which registers are saved or how parameters are
     passed.  Therefore, do any necessary things here, then jump to __start. */
  __asm__ volatile("
__start0:");
  /* We currently do not use r7 and r8; executables contain relocs. */
  /* probably not necessary */
  __asm__ volatile("move.d " __REG_PREFIX "sp,[" STR(C_SYMBOL_NAME(_System_stack)) "]");
  __asm__ volatile("move.d " __REG_PREFIX "r2," __REG_PREFIX "sp"); 
  __asm__ volatile("move.d " __REG_PREFIX "r6,[" STR(C_SYMBOL_NAME(_System_call_ptr)) "]");
  __asm__ volatile("move.d " __REG_PREFIX "r3,[" STR(C_SYMBOL_NAME(_Argc)) "]"); 
  __asm__ volatile("move.d " __REG_PREFIX "r4,[" STR(C_SYMBOL_NAME(_Argv)) "]");
  /* lives in posix/environ.c */
  __asm__ volatile("move.d " __REG_PREFIX "r5,[" STR(C_SYMBOL_NAME(__environ)) "]");
  /* for debugging */
  __asm__ volatile("move.d " __REG_PREFIX "r9,[" STR(C_SYMBOL_NAME(console_print_etrax)) "]");
  __asm__ volatile("jump " STR(C_SYMBOL_NAME(start1)));

  /* Note that this is only used for statically linked binaries.  The
     dynamic loader will change all references to .$System.call into the
     kernel entry address.  If dynamically linked objects were to use
     *this* entry, they would all have a dependency to the main program
     and not be shareable. */
  __asm__ volatile(".weak .$System.call
.$System.call:
	jump [" STR(C_SYMBOL_NAME(_System_call_ptr)) "]");
}

/* Make an alias called `start' (no leading underscore, so it can't
   conflict with C symbols) for `_start'.  This is the name vendor crt0.o's
   tend to use, and thus the name most linkers expect.  */
asm (".set start, __start");

extern void __NONE_set_memvals(int argc, char **argv, char **envp); /* brk.c */
extern void _Libctors(void);
extern void __aout__ctors (void) __attribute__ ((__weak__));
static void
start1 ()
{
#ifdef DEBUG
	console_print_etrax("In start1.\n");
#endif

	/* setup the heap pointers in brk.c */
	__NONE_set_memvals(_Argc, _Argv, __environ);

	/* Do C library initializations.  */
	__libc_init (_Argc, _Argv, __environ);

#if defined (__ELF__)
        /* Assume linux (with MMU and ELF, that is).  */
        {
          extern void _init (void);
          extern void _fini (void);
          _init ();
          if (atexit (_fini) != 0)
            exit (-1);
        }
#else
	__asm__ __volatile__ (".weak ___aout_ctors");
        if (__aout__ctors)
          __aout__ctors ();
#endif
	/* Call constructors in shared libraries. */
	_Libctors();

	/* Call the user program.  */
	exit (main (_Argc, _Argv, __environ));
}

