/* Copyright (C) 1995, 1996, 1998, 1999, 2000 Free Software Foundation, Inc.
This file is part of the GNU C Library.

The GNU C Library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

The GNU C Library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with the GNU C Library; see the file COPYING.LIB.  If
not, write to the Free Software Foundation, Inc., 675 Mass Ave,
Cambridge, MA 02139, USA.  */

#include <sysdep.h>
#include <sys/socketcall.h>

#define P(a, b) P2(a, b)
#define P2(a, b) a##b

	.text
/* The socket-oriented system calls are handled unusally in Linux.
   They are all gated through the single `socketcall' system call number.
   `socketcall' takes two arguments: the first is the subcode, specifying
   which socket function is being called; and the second is a pointer to
   the arguments to the specific function.

   The .S files for the other calls just #define socket and #include this.  */

#if defined(socket) && !defined(__socket)
#define __socket P(__libc_,socket)
#define ___socket P(___libc_,socket)
#endif
	
	.globl C_SYMBOL_NAME(__socket)
C_LABEL(__socket)
	/* we got arguments in r10, r11, r12 and r13, we need to stack them */
	push __PREFIX_REG(r13)
	push __PREFIX_REG(r12)
	push __PREFIX_REG(r11)
	push __PREFIX_REG(r10)
	
	/* Use ## so `socket' is a separate token that might be #define'd.  */
	/* Subcode is first arg to socketcall.  */
	movu.w P(SOCKOP_,socket), __PREFIX_REG(r10)
	/* Address of args is 2nd arg.  */
	move.d __PREFIX_REG(sp),__PREFIX_REG(r11)

	push __PREFIX_REG(r1)
	movu.w SYS_ify (socketcall), __PREFIX_REG(r1)
	CRIS_SYSCALL
	pop __PREFIX_REG(r1)
	addq	16,__PREFIX_REG(sp)			/* pop arguments */
	/* check return code for error */
	cmp.d -4095, __PREFIX_REG(r10)
	bcs 1f
	nop
	jump C_SYMBOL_NAME(__syscall_error)
1:	ret
	nop

	.weak	C_SYMBOL_NAME(socket)
C_SYMBOL_NAME(socket) = C_SYMBOL_NAME(__socket)

/* just so that the .S files in .. dont break.
 * we can simply not have multiline #defines in asm files so we cant use it */
#undef weak_alias
#define weak_alias(original,alias)


