/* Copyright (C) 1995, 1996, 1999, 2000 Free Software Foundation, Inc.
This file is part of the GNU C Library.

The GNU C Library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

The GNU C Library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with the GNU C Library; see the file COPYING.LIB.  If
not, write to the Free Software Foundation, Inc., 675 Mass Ave,
Cambridge, MA 02139, USA.  */

#include <sysdep.h>

	/*  void  *  mmap(void  *start,  size_t  length, int prot , int flags, int fd,
		          off_t offset);
	*/
	
	.text
	.globl C_SYMBOL_NAME(__mmap)
C_LABEL(__mmap)
	/* 6 arguments. CRIS ABI says the 4 first are in r10-r13, and the 2 last
	   are on the stack. Linux syscall old_mmap expects a pointer to a buffer
	   containing the 6 arguments. So we just stack r13-r10 and give it a ptr
	   to sp.

           NOTE we can obviously rewrite old_mmap into sys_mmap since we don't need
	   to be backwards compatible with anything, and pass arguments just like
	   we do in the rest of elinux. But this will do for now.
	*/

	push __PREFIX_REG(r13)
	push __PREFIX_REG(r12)
	push __PREFIX_REG(r11)
	push __PREFIX_REG(r10)

	/* Address of args is 1st arg.  */
	move.d __PREFIX_REG(sp),__PREFIX_REG(r10)

	push __PREFIX_REG(r1)
	movu.w SYS_ify(mmap),__PREFIX_REG(r1)	/* System call number in r1.  */

        /* Do the system call trap.  */
	CRIS_SYSCALL
	pop __PREFIX_REG(r1)
	
	/* Restore stack.  */
	addq 16,__PREFIX_REG(sp)

	/* check return code for error */
	cmp.d -4095, __PREFIX_REG(r10)
	bcs 1f
	nop
	jump C_SYMBOL_NAME(__syscall_error)
1:	ret
	nop
PSEUDO_END (__mmap)

	.globl C_SYMBOL_NAME(mmap)
C_SYMBOL_NAME(mmap) = C_SYMBOL_NAME(__mmap)
