/* Copyright (C) 1991, 1992, 1994, 1995, 1999, 2000 Free Software Foundation, Inc.
This file is part of the GNU C Library.

The GNU C Library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

The GNU C Library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with the GNU C Library; see the file COPYING.LIB.  If
not, write to the Free Software Foundation, Inc., 675 Mass Ave,
Cambridge, MA 02139, USA.  */

#include <sysdep.h>

/* fork specially implemented for elinux NO_MM port.
 * difference to vfork is that fork doesn't wait for the child to exit or fork.
 * a clone() with CLONE_VM does a fork without forking the memory segments 
 */

        void __fork();

__asm__ (".text\n\t"
	 ".globl " STR(C_SYMBOL_NAME(__fork)) "\n"
	 STR(C_LABEL(__fork)) "\n\t"
	 "clear.d " __REG_PREFIX "r10\n\t"  /* r10 is argument 1 to clone, the new stack pointer */
	 "movu.w 0x2111," __REG_PREFIX "r11\n\t" /* flags arg. SIGCHLD | CLONE_VM | CLONE_NO_WAIT*/
	 "push " __REG_PREFIX "r1\n\t"
	 "movu.w " STR(__NR_clone) "," __REG_PREFIX "r1\n\t"
	 STR(CRIS_SYSCALL) "\n\t"
	 "pop " __REG_PREFIX "r1\n\t"
	 "cmp.d -4095," __REG_PREFIX "r10\n\t"
	 "bcs 1f\n\t"
	 "nop\n\t"
	 "jump " STR(C_SYMBOL_NAME(__syscall_error)) "\n"
	 "1:\n\t"
	 "ret\n\t"
	 "nop\n\t");

weak_alias (__fork, fork)
