/* Copyright (C) 1991, 1994, 1995 Free Software Foundation, Inc.
   Ported to standalone by Joel Sherrill jsherril@redstone-emh2.army.mil,
     On-Line Applications Research Corporation.
 
This file is part of the GNU C Library.

The GNU C Library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

The GNU C Library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with the GNU C Library; see the file COPYING.LIB.  If
not, write to the Free Software Foundation, Inc., 675 Mass Ave,
Cambridge, MA 02139, USA.  */

#include <ansidecl.h>
#include <stdlib.h>

/* as long as we use kmalloc for this, dont make it larger than 2**x - 16 */
#define DEF_HEAP_SIZE 120000

PTR __curbrk;
PTR __rorig;
PTR __rlimit;

typedef void (*bozo)(char *buf);
extern bozo console_print_etrax;

int
DEFUN(__brk, (inaddr), PTR inaddr)
{
	if(!inaddr)
		return 0; /* this is called sometimes.. */

	if (((void *)inaddr > (void *)__rlimit ) || 
	    ((void *)inaddr < (void *)__rorig ) ) {
		console_print_etrax("__brk out of memory!\n");
		abort(); /* kill the process.. */
		return -1;
	}
	
	__curbrk = inaddr;
	return 0;
}

/* Initialization Code for Memory Allocation */
/* called from crt0.o */

PTR __C_heap_start;
int __C_heap_size;

#include <sys/mman.h>
 
void
__NONE_set_memvals(int argc, char **argv, char **envp)
{
	/* grab a heap from the kernel */
	__C_heap_size = DEF_HEAP_SIZE;
	__C_heap_start = mmap((void *)0, __C_heap_size, PROT_READ | PROT_WRITE,
			      MAP_SHARED | MAP_ANONYMOUS, 0, 0);
	
	__rorig  = __curbrk = __C_heap_start;
	__rlimit = __curbrk + __C_heap_size;
}

weak_alias (__brk, brk)

#if 0
/* kludged temporary versions of malloc/free */

__ptr_t
malloc(size_t len)
{
	return mmap((void *)0, len, PROT_READ | PROT_WRITE,
		    MAP_SHARED | MAP_ANONYMOUS, 0, 0);
}

__ptr_t
calloc(size_t len, size_t size)
{
	int *res;
	len *= size;
	res = mmap((void *)0, len, PROT_READ | PROT_WRITE,
		   MAP_SHARED | MAP_ANONYMOUS, 0, 0);
#if 0
	/* our kludged mmap zeroes memory anyway. */
	memset(res, 0, len);
#endif
	return res;
}

void
free(__ptr_t ptr)
{
	munmap(ptr, 0);
}
#endif
