/* Copyright (C) 1991, 1992, 1999, 2000 Free Software Foundation, Inc.
This file is part of the GNU C Library.

The GNU C Library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

The GNU C Library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with the GNU C Library; see the file COPYING.LIB.  If
not, write to the Free Software Foundation, Inc., 675 Mass Ave,
Cambridge, MA 02139, USA.  */

#include <sysdep.h>
#include <stddef.h>		/* For size_t.  */
#include "stdlib/exit.h"

extern void
_Libdtors(void);

/* The function exit from glibc will not be called since it is
   overridden by the exit function in libgcc2.  So we must provide a
   cris__call_atexit_funcs function. 
   This is a good place, since __exit is already here.

   This function contains a duplicate of $srcdir/stdlib/exit.c and need
   to be kept in sync.  */
void
__cris__call_atexit_funcs (int status)
{
  /* We do it this way to handle recursive calls to exit () made by
     the functions registered with `atexit' and `on_exit'. We call
     everyone on the list and use the status value in the last
     exit (). */
  for (; __exit_funcs; __exit_funcs = __exit_funcs->next)
    {
      while ((__exit_funcs->idx)-- > 0)
	{
	  const struct exit_function *const f =
	    &__exit_funcs->fns[__exit_funcs->idx];
	  switch (f->flavor)
	    {
	    case ef_free:
	    case ef_us:
	      break;
	    case ef_on:
	      (*f->func.on.fn) (status, f->func.on.arg);
	      break;
	    case ef_at:
	      (*f->func.at) ();
	      break;
	    }
	}
    }

  /* Call destructors in libraries. */
  _Libdtors();
}

PSEUDO (_exit, exit, 1)
	/* Shouldn't get here.  */
PSEUDO_END(_exit)
