/* Assembler macros for Etrax.
   Copyright (C) 1991, 92, 93, 95, 96, 00 Free Software Foundation, Inc.
   This file is part of the GNU C Library.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

#include <sysdeps/generic/sysdep.h>

#define string_alias(x,y)

#ifdef	ASSEMBLER

/* Syntactic details of assembler.  */

/* It is *not* true that "ELF uses byte-counts for .align, most others
   use log2 of count of bytes" (../i386/sysdep.h).  See "align" in
   gas/read.c which is not overridden by gas/config/obj-elf.c.  It takes
   a log2 argument.  *Some* targets override it to take a byte argument.
   Why oh why don't people read source instead of getting information
   from less certain channels.  */
#define ALIGNARG(log2) log2

#ifdef HAVE_ELF

/* For ELF we need the `.type' directive to make shared libs work right.  */
#define ASM_TYPE_DIRECTIVE(name,typearg) .type name,typearg
#define ASM_SIZE_DIRECTIVE(name) .size name,.-name

/* Do *not* assume that ELF implies NO_UNDERSCORES.  The preprocessor
   macro __NO_UNDERSCORES__ will be defined (for gcc-cris) if so.  Use
   it when necessary (or NO_UNDERSCORES, as defined by the configury).  */

#else

/* For (older) a.out tool suites, don't provide .type and .size.  */
#define ASM_TYPE_DIRECTIVE(name,type)	/* Nothing is specified.  */
#define ASM_SIZE_DIRECTIVE(name)	/* Nothing is specified.  */

#endif

#ifdef	NO_UNDERSCORES
#define __PREFIX_REG(r) $r
#else
#define __PREFIX_REG(r) r
#endif

#define JUMPTARGET(name)	name

#endif	/* ASSEMBLER */

#ifdef	NO_UNDERSCORES
#define __REG_PREFIX "$"
#else
#define __REG_PREFIX
#endif

