/* Copied from the CRIS-specific, non-system-specific main setjmp.h
   Copyright (C) 1999  Axis Communications AB, Lund, Sweden.  */

/*
   Note that we save and restore CCR to be able to
   correctly handle DI/EI.  Note also that the "move x,ccr" does NOT affect
   the DMA enable bits (E and D).

   jmp_buf[0] - PC
   jmp_buf[1] - SP (R14)
   jmp_buf[2] - R13
   jmp_buf[3] - R12
   jmp_buf[4] - R11
   jmp_buf[5] - R10
   jmp_buf[6] - R9
   jmp_buf[7] - R8
   jmp_buf[8] - R7
   jmp_buf[9] - R6
   jmp_buf[10] - R5
   jmp_buf[11] - R4
   jmp_buf[12] - R3
   jmp_buf[13] - R2
   jmp_buf[14] - R1
   jmp_buf[15] - R0
   jmp_buf[16] - SRP
   jmp_buf[17] - CCR
   */

#ifndef	_ASM
typedef unsigned long int __jmp_buf[18];
#endif

#if	defined (__USE_MISC) || defined (_ASM)
#define JB_SP 1
#endif

/* Test if longjmp to JMPBUF would unwind the frame
   containing a local variable at ADDRESS.  */
#define _JMPBUF_UNWINDS(jmpbuf, address) \
  ((unsigned long int) (address) < (jmpbuf)[JB_SP])
