/* float.h for cris */
/* this file really belongs in the gcc-cris lib instead, but I had to add the
   LDBL stuff to make glibc happy.
   (Above written by bjornw.)

   That was true for old versions.  Now GCC has a real float.h.  With
   newer versions of glibc, this file should go away.  For now, we
   include a copy of gcc/config/float-i64.h that we use for gcc with the
   newer ABI, where the size of double is 64 bits.  */

#ifndef _FLOAT_H
#define _FLOAT_H
#if !defined (__CRIS_ABI_version) || __CRIS_ABI_version < 2

#define FLT_RADIX 2
#define FLT_MANT_DIG 24
#define FLT_DIG 6
#define FLT_ROUNDS 1
#define FLT_EPSILON ((float)1.19209290e-07)
#define FLT_MIN_EXP (-125)
#define FLT_MIN ((float)1.17549435e-38)
#define FLT_MIN_10_EXP (-37)
#define FLT_MAX_EXP 128
#define FLT_MAX ((float)3.40282347e+38)
#define FLT_MAX_10_EXP 38
#define HUGE_VAL FLT_MAX

#define DBL_MANT_DIG 48
#define DBL_DIG FLT_DIG
#define DBL_EPSILON FLT_EPSILON
#define DBL_MIN_EXP FLT_MIN_EXP
#define DBL_MIN FLT_MIN
#define DBL_MIN_10_EXP FLT_MIN_10_EXP
#define DBL_MAX FLT_MAX
#define DBL_MAX_10_EXP FLT_MAX_10_EXP
#define DBL_MAX_EXP FLT_MAX_EXP

#define LDBL_MANT_DIG FLT_MANT_DIG
#define LDBL_DIG FLT_DIG
#define LDBL_EPSILON FLT_EPSILON
#define LDBL_MIN_EXP FLT_MIN_EXP
#define LDBL_MIN FLT_MIN
#define LDBL_MIN_10_EXP FLT_MIN_10_EXP
#define LDBL_MAX FLT_MAX
#define LDBL_MAX_10_EXP FLT_MAX_10_EXP
#define LDBL_MAX_EXP FLT_MAX_EXP

#else  /* __CRIS_ABI_version >= 2 */

   /* Radix of exponent representation */
#undef FLT_RADIX
#define FLT_RADIX 2
   /* Number of base-FLT_RADIX digits in the significand of a float */
#undef FLT_MANT_DIG
#define FLT_MANT_DIG 24
   /* Number of decimal digits of precision in a float */
#undef FLT_DIG
#define FLT_DIG 6
   /* Addition rounds to 0: zero, 1: nearest, 2: +inf, 3: -inf, -1: unknown */
#undef FLT_ROUNDS
#define FLT_ROUNDS 1
   /* Difference between 1.0 and the minimum float greater than 1.0 */
#undef FLT_EPSILON
#define FLT_EPSILON 1.19209290e-07F
   /* Minimum int x such that FLT_RADIX**(x-1) is a normalised float */
#undef FLT_MIN_EXP
#define FLT_MIN_EXP (-125)
   /* Minimum normalised float */
#undef FLT_MIN
#define FLT_MIN 1.17549435e-38F
   /* Minimum int x such that 10**x is a normalised float */
#undef FLT_MIN_10_EXP
#define FLT_MIN_10_EXP (-37)
   /* Maximum int x such that FLT_RADIX**(x-1) is a representable float */
#undef FLT_MAX_EXP
#define FLT_MAX_EXP 128
   /* Maximum float */
#undef FLT_MAX
#define FLT_MAX 3.40282347e+38F
   /* Maximum int x such that 10**x is a representable float */
#undef FLT_MAX_10_EXP
#define FLT_MAX_10_EXP 38

   /* Number of base-FLT_RADIX digits in the significand of a double */
#undef DBL_MANT_DIG
#define DBL_MANT_DIG 53
   /* Number of decimal digits of precision in a double */
#undef DBL_DIG
#define DBL_DIG 15
   /* Difference between 1.0 and the minimum double greater than 1.0 */
#undef DBL_EPSILON
#define DBL_EPSILON 2.2204460492503131e-16
   /* Minimum int x such that FLT_RADIX**(x-1) is a normalised double */
#undef DBL_MIN_EXP
#define DBL_MIN_EXP (-1021)
   /* Minimum normalised double */
#undef DBL_MIN
#define DBL_MIN 2.2250738585072014e-308
   /* Minimum int x such that 10**x is a normalised double */
#undef DBL_MIN_10_EXP
#define DBL_MIN_10_EXP (-307)
   /* Maximum int x such that FLT_RADIX**(x-1) is a representable double */
#undef DBL_MAX_EXP
#define DBL_MAX_EXP 1024
   /* Maximum double */
#undef DBL_MAX
#define DBL_MAX 1.7976931348623157e+308
   /* Maximum int x such that 10**x is a representable double */
#undef DBL_MAX_10_EXP
#define DBL_MAX_10_EXP 308

   /* Number of base-FLT_RADIX digits in the significand of a long double */
#undef LDBL_MANT_DIG
#define LDBL_MANT_DIG 53
   /* Number of decimal digits of precision in a long double */
#undef LDBL_DIG
#define LDBL_DIG 15
   /* Difference between 1.0 and the minimum long double greater than 1.0 */
#undef LDBL_EPSILON
#define LDBL_EPSILON 2.2204460492503131e-16L
   /* Minimum int x such that FLT_RADIX**(x-1) is a normalised long double */
#undef LDBL_MIN_EXP
#define LDBL_MIN_EXP (-1021)
   /* Minimum normalised long double */
#undef LDBL_MIN
#define LDBL_MIN 2.2250738585072014e-308L
   /* Minimum int x such that 10**x is a normalised long double */
#undef LDBL_MIN_10_EXP
#define LDBL_MIN_10_EXP (-307)
   /* Maximum int x such that FLT_RADIX**(x-1) is a representable long double */
#undef LDBL_MAX_EXP
#define LDBL_MAX_EXP 1024
   /* Maximum long double */
#undef LDBL_MAX
#define LDBL_MAX 1.7976931348623157e+308L
   /* Maximum int x such that 10**x is a representable long double */
#undef LDBL_MAX_10_EXP
#define LDBL_MAX_10_EXP 308
#endif /* __CRIS_ABI_version >= 2  */
#endif				/* _FLOAT_H */
