/* Machine-dependent pthreads configuration and inline functions.

   $Id: pt-machine.h,v 1.2 2000/10/11 01:36:31 hp Exp $

   Etrax version.

   Copyright (c) 1999, 2000 Axis Communications AB

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */


/* For compatibility with older toolsuite that does not know about an
   optional register prefix.  */
#ifndef __REG_PREFIX
#ifdef __NO_UNDERSCORES__
#define __REG_PREFIX "$"
#else
#define __REG_PREFIX
#endif
#endif

/* Spinlock implementation; required.  */
extern inline int
testandset (int *spinlock)
{
	int ret;

	/* we don't have any TAS instruction - we need to disable IRQ's, then do the
	 * test and set manually, then re-enable IRQ's.
	 * How this will work with a protected environment later - don't ask me.
	 *
	 * Well, you can ask _me_, now that we have one.  Here it is,
	 * fresh from the document example.  FIXME: Revisit everything; is a
	 * TAS better than cmpxchg?
	 */

	/* FIXME: Check that using a byte-part is enough.  Otherwise, we
	   must ensure that the spinlock is 32-bit-aligned.  */

#if defined (__CRIS_arch_version) && __CRIS_arch_version >= 10
	/* Note that making *spinlock an output (or input) is unnecessary
	   as we have a memory clobber.  */
	__asm__ __volatile__ ("clearf\n"
			      "0:\n\t"
			      "move.b [%1],%0\n\t"
			      "ax\n\t"
			      "move.b %2,[%1]\n\t"
			      "bwf 0b\n\t"
			      "clearf"
			      : "=&r" (ret)
			      : "r" (spinlock), "r" ((int) 1)
			      : "memory");
#else
	__asm__ __volatile__ ("move " __REG_PREFIX "ccr," __REG_PREFIX "r11\n\t"
			      "di\n\t"
			      "move.d %0," __REG_PREFIX "r12\n\t"
			      "move.d %1,%0\n\t"
			      "move.d " __REG_PREFIX "r12,%1\n\t"
			      "move " __REG_PREFIX "r11," __REG_PREFIX "ccr\n\t"
			      : "=r"(ret), "=m"(*spinlock)
			      : "0"(1), "m"(*spinlock)
			      : "r11", "r12", "memory");
#endif
	return ret;
}


/* Get some notion of the current stack.  Need not be exactly the top
   of the stack, just something somewhere in the current frame.  */
#define CURRENT_STACK_FRAME  stack_pointer
register char * stack_pointer __asm__ ("sp");


#if 0
/* Compare-and-swap for semaphores.
   Available on the 486 and above, but not on the 386.
   We test dynamically whether it's available or not. */

#define HAS_COMPARE_AND_SWAP

extern inline int
__compare_and_swap (long int *p, long int oldval, long int newval)
{
  char ret;
  long int readval;

  __asm__ __volatile__ ("lock; cmpxchgl %3, %1; sete %0"
			: "=q" (ret), "=m" (*p), "=a" (readval)
			: "r" (newval), "m" (*p), "a" (oldval));
  return ret;
}
#endif

