/* 
 * test.h -- Test layer used to verify stack       
 *
 * Copyright (C) 2000  Axis Communications AB
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Id: test.h,v 1.7 2000/11/13 15:43:28 matsf Exp $x
 *
 */

#ifndef TEST_H
#define TEST_H

/****************** INCLUDE FILES SECTION ***********************************/

#ifdef __KERNEL__
#include <linux/bluetooth/btcommon.h>
#else
#include "btcommon.h"
#endif

/****************** CONSTANT AND MACRO SECTION ******************************/

extern l2cap_con *testcon;
extern l2cap_con *testcon2;
extern l2cap_con *testcon3;

/****************** TYPE DEFINITION SECTION *********************************/

/****************** EXPORTED FUNCTION DECLARATION SECTION *******************/
void test_init(void);
void test_shutdown(void);
s32 test_connect_req(BD_ADDR bd);
s32 test_connect_psmreq(BD_ADDR bd, u16 psm);
void test_connect_ind(l2cap_con *l2cap);
void test_connect_cfm(l2cap_con *l2cap, s32 status);
void test_connect_pnd(l2cap_con *l2cap, s32 status);
void test_config_ind(l2cap_con* l2cap);
void test_config_cfm(l2cap_con *l2cap, s32 status);
s32 test_disconnect_req(l2cap_con *con);
void test_disconnect_ind(l2cap_con *l2cap);
void test_disconnect_cfm(l2cap_con *l2cap);
void test_receive_data(l2cap_con *l2cap, u8 *data, u32 len);
s32 test_send_data(l2cap_con *con, u8 *testdata, s32 len);


void test2_init(void);
void test2_shutdown(void);
s32 test2_connect_req(BD_ADDR bd);
s32 test2_connect_psmreq(BD_ADDR bd, u16 psm);
void test2_connect_ind(l2cap_con *l2cap);
void test2_connect_cfm(l2cap_con *l2cap, s32 status);
void test2_connect_pnd(l2cap_con *l2cap, s32 status);
void test2_config_ind(l2cap_con* l2cap);
void test2_config_cfm(l2cap_con *l2cap, s32 status);
s32 test2_disconnect_req(l2cap_con *con);
void test2_disconnect_ind(l2cap_con *l2cap);
void test2_disconnect_cfm(l2cap_con *l2cap);
void test2_receive_data(l2cap_con *l2cap, u8 *data, u32 len);
s32 test2_send_data(l2cap_con *con, u8 *testdata, s32 len);



#endif
/****************** END OF FILE sdp.h ***************************************/
