/* 
 * tcs.h -- Implementation of Bluetooth Telephony Control Protocol 
 *          Specification, TCS Binary
 *
 * Copyright (C) 2000  Axis Communications AB
 *
 * Mattias Agren <mattias.agren@axis.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Id: tcs.h,v 1.5 2000/08/14 11:56:40 matsf Exp $
 *
 */

#ifndef TCS_H
#define TCS_H

/****************** INCLUDE FILES SECTION ***********************************/
#ifdef __KERNEL__
#include <linux/types.h>
#include <linux/bluetooth/btcommon.h>
#else
#include "btcommon.h"
#include "local.h"
#endif

/****************** CONSTANT AND MACRO SECTION ******************************/

/****************** TYPE DEFINITION SECTION *********************************/

enum tcs_states{STATE_NULL, CALL_INITIATED, OVERLAP_SENDING,
		OUTGOING_CALL_PROCEEDING, CALL_DELIVERED, CALL_PRESENT,
		CALL_RECEIVED, CONNECT_REQUEST, INCOMMING_CALL_PROCEEDING,
		OVERLAP_RECEIVING, ACTIVE, DISCONNECT_REQUEST,
		DISCONNECT_INDICATION, RELEASE_REQUEST};

typedef struct tcs_con {
	l2cap_con *l2cap;
	u16 sco_hdl;
	u16 acl_hdl;
	enum tcs_states tcs_cur_state;
} tcs_con;

/****************** EXPORTED FUNCTION DECLARATION SECTION *******************/
void tcs_init(void);
void tcs_shutdown(void);
s32 tcs_connect_req(u8 *bd);
void tcs_connect_ind(l2cap_con *l2cap);
void tcs_connect_cfm(l2cap_con *l2cap, s32 status);
void tcs_config_ind(l2cap_con* l2cap);
void tcs_config_cfm(l2cap_con *l2cap, s32 status);
void tcs_disconnect_req(u32 tcs_hdl);
void tcs_disconnect_ind(l2cap_con *l2cap);
void tcs_disconnect_cfm(l2cap_con *l2cap);
void tcs_receive_data(l2cap_con *l2cap, u8* data, u32 len);

s32 tcs_connect(l2cap_con *l2cap);
s32 tcs_disconnect(l2cap_con *l2cap);
s32 tcs_send_information(l2cap_con *l2cap, u8 ch);
s32 tcs_setup(l2cap_con *l2cap, u8 *nbr, u8 nbr_len);
s32 tcs_add_sco_link(u8 err_code, u32 hci_hdl);

#endif
/****************** END OF FILE tcs.h ***************************************/
