/* 
 * sdp.h -- Implementation of Bluetooth Service Discovery Protocol 
 *
 * Copyright (C) 2000  Axis Communications AB
 *
 * Mats Friden <mats.friden@axis.com> 
 *
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Id: sdp.h,v 1.21 2000/11/13 15:43:28 matsf Exp $
 *
 */

#ifndef SDP_H
#define SDP_H

/****************** INCLUDE FILES SECTION ***********************************/

#ifdef __KERNEL__
#include <linux/types.h>
#include <linux/bluetooth/btcommon.h>
#else
#include "btcommon.h"
#include "local.h"
#endif

/****************** CONSTANT AND MACRO SECTION ******************************/
#define SERPORT_PROFILE 0
#define LAN_PROFILE 1


/****************** TYPE DEFINITION SECTION *********************************/


/****************** EXPORTED FUNCTION DECLARATION SECTION *******************/
extern struct proc_dir_entry sdp_proc_entry;

void sdp_init(void);
void sdp_shutdown(void);
s32 sdp_connect_req(u8* bd_addr);
void sdp_connect_ind(l2cap_con *l2cap);
void sdp_connect_pnd(l2cap_con *l2cap, int status);
void sdp_connect_cfm(l2cap_con *l2cap, s32 status);
void sdp_config_ind(l2cap_con* l2cap);
void sdp_config_cfm(l2cap_con *l2cap, s32 status);
void sdp_disconnect_req(u32 sdp_hdl);
void sdp_disconnect_ind(l2cap_con *l2cap);
void sdp_disconnect_cfm(l2cap_con *l2cap);
void sdp_receive_data(l2cap_con *l2cap, u8* data, u32 len);

#endif
/****************** END OF FILE sdp.h ***************************************/
