/* 
 * rfcomm.c --  Implementation of Bluetooth RFCOMM with TS 07.10, 
 *              Serial Port Emulation
 *
 * Copyright (C) 2000  Axis Communications AB
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Id: rfcomm.h,v 1.28 2000/11/15 08:54:53 matsf Exp $
 *
 */

#ifndef RFCOMM_H
#define RFCOMM_H

/****************** INCLUDE FILES SECTION ***********************************/
#ifdef __KERNEL__
#include <linux/types.h>
#include <linux/bluetooth/btcommon.h>
#else
#include "local.h"
#include "btcommon.h"
#endif

/****************** CONSTANT AND MACRO SECTION ******************************/

#define SET_RFCOMM_CONID(line, dlci) ((RFCOMM_LAYER << 16) | \
				      (((line) << 8) & 0xff) | \
				      ((dlci) & 0xff))

#ifdef CONFIG_SVINTO2
#include <asm/svinto.h>
#endif

#define RFCOMM_MAGIC 0x1234

#define PPP_DLCI 2
/* The virtual port for ppp */
#define CTRL_CHAN 0
/* The control channel is defined as DLCI 0 in rfcomm */
#define MCC_CMD 1
/* Multiplexer command */
#define MCC_RSP 0
/* Multiplexer response */

/****************** TYPE DEFINITION SECTION *********************************/

/* An rfcomm connection is described by the physical connection to another
   device, the l2cap_con, and the emulated serial ports on this connection,
   active_ports */


/* These two are placed here temporary during the UnPlugFest */

typedef struct parameter_mask{
	u8 bit_rate:1;
	u8 data_bits:1;
	u8 stop_bit:1;
	u8 parity:1;
	u8 parity_type:1;
	u8 xon_u8:1;
	u8 xoff_u8:1;
	u8 res1:1;
	u8 xon_input:1;
	u8 xon_output:1;
	u8 rtr_input:1;
	u8 rtr_output:1;
	u8 rtc_input:1;
	u8 rtc_output:1;
	u8 res2:2;
} parameter_mask;

typedef struct rpn_values{
	u8 bit_rate;
	u8 data_bits:2;
	u8 stop_bit:1;
	u8 parity:1;
	u8 parity_type:2;
	u8 res1:2;
	u8 xon_input:1;
	u8 xon_output:1;
	u8 rtr_input:1;
	u8 rtr_output:1;
	u8 rtc_input:1;
	u8 rtc_output:1;
	u8 res2:2;
	u8 xon_u8;
	u8 xoff_u8;
	parameter_mask pm;
} rpn_values;

/****************** EXPORTED FUNCTION DECLARATION SECTION *******************/

void rfcomm_init(void);
void rfcomm_close(void);
u32 rfcomm_connect_req(u8* bd_addr, s32 server_chan, s32 line);
void rfcomm_connect_ind(l2cap_con *l2cap);
void rfcomm_connect_pnd(l2cap_con *l2cap, int status);
void rfcomm_connect_cfm(l2cap_con *l2cap, s32 status);
void rfcomm_config_ind(l2cap_con* l2cap);
void rfcomm_config_cfm(l2cap_con *l2cap, s32 status);
void rfcomm_disconnect_ind(l2cap_con *l2cap);
void rfcomm_disconnect_cfm(l2cap_con *l2cap);
void rfcomm_receive_data(l2cap_con *l2cap, u8 *data, u32 len);
s32 rfcomm_send_data(u32 con_id, u8 *data, u32 count);
void rfcomm_disconnect_req(u8 line);
void rfcomm_send_testdata(u32 count, u8 line);
void rfcomm_print_status(void);
s32 rfcomm_sprint_status(u8 *buf);

s32 rfcomm_test_msg(rfcomm_con *rfcomm, u8 *test_pattern, u32 len, u8 cr);
s32 rfcomm_fcon_msg(rfcomm_con *rfcomm, u8 cr);
s32 rfcomm_fcoff_msg(rfcomm_con *rfcomm, u8 cr);
s32 rfcomm_rpn_msg(rfcomm_con *rfcomm, u8 cr, u8 dlci, u8 req);
s32 rfcomm_rls_msg(rfcomm_con *rfcomm, u8 cr, u8 dlci, u8 err_code);
s32 rfcomm_set_mtu(rfcomm_con *rfcomm, u8 dlci, u32 new_mtu);
s32 rfcomm_msc_msg(rfcomm_con *rfcomm, u8 value, u8 cr, u8 dlci);
s32 rfcomm_sabm_msg(rfcomm_con *rfcomm, u8 dlci);
s32 rfcomm_pn_msg(rfcomm_con *rfcomm, u8 dlci, u8 credits, u32 frame_size);
s32 rfcomm_crap_msg(rfcomm_con *rfcomm);
s32 rfcomm_send_credits(rfcomm_con *rfcomm, u8 dlci, u8 credits);
#endif
/****************** END OF FILE rfcomm.h ************************************/

