/* 
 * l2cap_internal.h --  Implementation of Bluetooth Logical Link Control 
 *                      and Adaption Protocol (L2CAP), Internal definitions
 *
 * Copyright (C) 2000  Axis Communications AB
 *
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 *
 */

#ifndef L2CAP_INTERNAL_H
#define L2CAP_INTERNAL_H

/****************** INCLUDE FILES SECTION ***********************************/


/****************** CONSTANT AND MACRO SECTION ******************************/

/* FIXME --  make this a function with default case */
static const u8* state_name[] = {
	"CLOSED",
	"W4_L2CAP_CONNECT_RSP",
	"W4_L2CA_CONNECT_RSP",
	"CONFIG",
	"OPEN", 
	"W4_L2CAP_DISCONNECT_RSP",
	"W4_L2CA_DISCONNECT_RSP",
	"ANY_STATE"
};

static const u8* bool2str[] = {
	"no",
	"yes", 
};


/****************** TYPE DEFINITION SECTION *********************************/



/****************** EXPORTED FUNCTION DECLARATION SECTION *******************/

u16 get_cid(void);
const u8* psm2str(u16 psm);


/*********************************************************************/
/*---------------------- INIT AND SHUTDOWN --------------------------*/
/*********************************************************************/


/*******************************************************************/
/*-------------------------- ACTIONS ------------------------------*/
/*******************************************************************/


#endif
/****************** END OF FILE l2cap_internal.h *****************************/
