/* 
 * l2cap_con.h --  Implementation of Bluetooth Logical Link Control 
 *                 and Adaption Protocol (L2CAP), Connection Manager   
 *
 * Copyright (C) 2000  Axis Communications AB
 *
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 *
 */

#ifndef L2CAP_CON_H
#define L2CAP_CON_H

/****************** INCLUDE FILES SECTION ***********************************/

#ifdef __KERNEL__
#include <linux/bluetooth/btcommon.h>
#include <linux/types.h>
#else
#include "btcommon.h"
#endif

/****************** CONSTANT AND MACRO SECTION ******************************/

/* internal test of connection manager */
#define L2CAP_SELFTEST 0


/****************** TYPE DEFINITION SECTION *********************************/



/****************** EXPORTED FUNCTION DECLARATION SECTION *******************/


/*********************************************************************/
/*---------------------- INIT AND SHUTDOWN --------------------------*/
/*********************************************************************/

void init_con_list(void);
void free_list(void);

l2cap_con* create_con(u16 hci_hdl, CID lcid, CID rcid);
s32 delete_con(l2cap_con *con);

void insert_con(l2cap_con *con);
void reset_con(l2cap_con* con);
l2cap_con* get_first_con(void);
l2cap_con* get_next_con(l2cap_con* con);

void init_flow(flow *f);

/*******************************************************************/
/*-------------------------- ACTIONS ------------------------------*/
/*******************************************************************/

l2cap_con* get_rcon(CID rcid);
l2cap_con* get_lcon(CID lcid);
l2cap_con* get_con(BD_ADDR bd, s32 STATE);
l2cap_con* get_con_hcihdl(u16 hdl);
l2cap_con* check_remote_cid(u16 hdl, CID remote_cid);

u16 get_cid(void);
void show_con(const u8* head, l2cap_con* con);
void show_list(void);
s32 count_con(u16 hci_hdl);

#if L2CAP_SELFTEST
void test_conlist(void);
s32 remove_rcid(CID rcid);
#endif

s32 l2cap_sprint_con(u8 *buf, l2cap_con* con);
s32 l2cap_sprint_active(u8 *buf);

#endif
/****************** END OF FILE l2cap_con.h *********************************/
