/* 
 * btdebug.h --  Miscellaneous debug functions and defines
 *        
 * Copyright (C) 2000  Axis Communications AB
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Id: btdebug.h,v 1.27 2000/11/15 17:10:23 matsf Exp $
 *
 */

#ifndef BTDEBUG_H
#define BTDEBUG_H

#ifdef __KERNEL__
#include <linux/kernel.h>
#include <linux/types.h>
#else
#include <stdio.h>
#include "local.h"
#define printk printf
#endif

#define BT_SYS_STR "BT SYS: "

/* Always defined */
#define D_ERR(fmt...) printk(BT_SYS_STR"ERROR :" fmt)
#define D_WARN(fmt...) printk(BT_SYS_STR"warning :" fmt)

/***************** Over all debug and system print outs **********************/

#define BT_SYSTEM_DEBUG 1

#if BT_SYSTEM_DEBUG
#define DSYS(fmt...) printk(BT_SYS_STR fmt)
#else
#define DSYS(fmt...)
#endif

/***************** Bluetooth Debug defines ***********************************/

#define BT_DATA_DEBUG 0
#define BT_DATAFLOW_DEBUG 0 /* print pkt */

#define BT_DRIVER_DEBUG 0
#define BT_LDISC_DEBUG 0

#define BT_DBG_STR "BT " 

/****************** HCI Debug defines ****************************************/
/* Possibility to turn on/off debug for separate sections, in the hci layer */

#define DEBUG_HCI_QUEUEING 0
/* Debug for the queueing when sending data */

#define DEBUG_HCI_INDATA 0
/* Prints out how many characters that is received by hci_recieve_data() */

#define DEBUG_HCI_RECEIVING_PROCESS 0
/* Will enable/disable debug during the receiving process */

#define DEBUG_HCI_SEND_PROCESS 0
/* Will enable/disable debug during the sending process */

#define DEBUG_DATAFLOW 0
/* Enables / disables the printing of the bytes thar are sent/received */

#define DEBUG_HCI_CTRL 0
/* Enables / disables debug for the HCI control and signaling */

#define DEBUG_HCI_CMD 0
/* Enables / disables debug for the HCI commands */

#define HCI_DBG_STR "HCI: "

/***************** L2CAP Debug defines ***************************************/

#define L2CAP_DEBUG_STATE 0
#define L2CAP_DEBUG_TIMER 0
#define L2CAP_DEBUG_CON 0
#define L2CAP_DEBUG_RCV 0
#define L2CAP_DEBUG_XMIT 0
#define L2CAP_DEBUG_MISC 0
#define L2CAP_DEBUG_DATA 0

#define L2CAP_DBG_STR "    L2CAP "

/***************** RFCOMM Debug defines **************************************/

/* Possibility to turn on/off debug for seperate sections  in RFCOMM*/

#define DEBUG_RFCOMM_RECEIVE_FLOW 0
/* Will enable/disable debug during the receiving process */

#define DEBUG_RFCOMM_SEND_PROCESS 0
/* Will enable/disable debug during the sending process */

#define DEBUG_RFCOMM_INTERNAL_SIGNALING 0
/* Will enable/disable debug for the internal signaling between the RFCOMM
   layers on two differnet BT-units */

#define PRINT_DATA_ENABLE 0
/* Enables /disables the printing of the send and received data */

#define RFCOMM_DBG_STR "          RFCOMM "

/***************** SDP Debug defines *****************************************/

#define SDP_DEBUG_XMIT 0
/* Enables/disables the debug when sdp is transmitting data */

#define SDP_DEBUG_REC 0
/* Enables/disables the debug when sdp is receiving data */

#define SDP_DEBUG_MISC 0
/* Enables/disables debug for functions used during connection and
   disconnecting i sdp */

#define SDP_DEBUG_MEM 0

#define SDP_DEBUG_PROC 0

#define SDP_PRINT_DATA 0

#define SDP_DBG_STR "          SDP "

/***************** TCS Debug defines ***************************************/

#define TCS_DEBUG_MISC 0
#define TCS_DEBUG_XMIT 0
#define TCS_PRINT_DATA 0
#define TCS_DEBUG_REC 0

/***************** BTMEM Debug defines ***************************************/

#define BTMEM_DEBUG 0

#define BTMEM_DBG_STR "    BTMEM "

/***************** Function declaration section ******************************/

void print_data(const u8 *message, u8 *buf, s32 len);

#endif
/****************** END OF FILE btdebug.h ************************************/
