/* 
 * bluetooth.h -- Linux kernel integration code for bluetooth stack
 *
 * Copyright (C) 2000  Axis Communications AB
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Id: bluetooth.h,v 1.29 2000/11/15 08:54:53 matsf Exp $x
 */

#ifndef BLUETOOTH_H
#define BLUETOOTH_H

#ifndef BTD_USERSTACK
#include <linux/bluetooth/btcommon.h>
#else
#include "btcommon.h"
#endif

/* glue functions */
s32 bt_write_lower_driver(u8 *data, s32 len);
s32 bt_receive_top(u32 con_id, u8 *data, s32 len);

void parse_event(u8 *event);
s32 check_event(u8 event);

/***********************************/
/* Init, shutdown and registration */
/***********************************/

s32 bt_init(void);

s32 bt_register_rfcomm(rfcomm_con *rfcomm, u8 dlci);
s32 bt_unregister_rfcomm(s32 line);
s32 bt_register_tty(struct tty_struct *tty);
s32 bt_unregister_tty(struct tty_struct *tty, s32 line);
s32 bt_registered(struct tty_struct *tty);

void bt_shutdown(void);
void show_bt_version(void);
char *get_hw_name(s32 hw_type);
s32 bt_set_hw(s32 hw_type);
void bt_hangupline(s32 line);
void bt_feedstack(void);


/******************/
/* Misc functions */
/******************/

int bt_initiated(void);
void bt_rfcomm_connection_ready(s32 status);
void bt_sdp_connection_ready(s32 status);
s32 bt_sprint_status(u8 *buf);

#endif
/****************** END OF FILE bluetooth.h *********************************/
