/* $Id: sigcontext.h,v 1.3 1998/11/23 20:36:50 bjornw Exp $ */

#ifndef _ASMETRAX_SIGCONTEXT_H
#define _ASMETRAX_SIGCONTEXT_H

#include <asm/ptrace.h>

/* This struct is saved by setup_frame in signal.c, to keep the current context while
   a signal handler is executed. It's restored by sys_sigreturn.

   To keep sys_sigreturn simple, the pt_regs structure is intentionally put at the upmost
   adress. That way, sigreturn doesn't actually need to do any real stack magic to cut the
   sigcontext out from the stack - it just have to increase sp so it points to regs in the
   sigcontext. 
*/

struct sigcontext_struct {
	unsigned long oldmask;
	struct pt_regs regs;
};

#endif

