/* $Id: semaphore.h,v 1.6 1998/09/25 10:39:58 bjornw Exp $ */

/* On the i386 these are coded in asm, perhaps we should as well. Later.. */

#ifndef _ETRAX_SEMAPHORE_H
#define _ETRAX_SEMAPHORE_H

#include <asm/system.h>
#include <asm/atomic.h>

/*
 * SMP- and interrupt-safe semaphores..
 *
 * (C) Copyright 1996 Linus Torvalds
 *
 * Modified 1996-12-23 by Dave Grothe <dave@gcom.com> to fix bugs in
 *                     the original code and to make semaphore waits
 *                     interruptible so that processes waiting on
 *                     semaphores can be killed.
 *
 * If you would like to see an analysis of this implementation, please
 * ftp to gcom.com and download the file
 * /pub/linux/src/semaphore/semaphore-2.0.24.tar.gz.
 *
 */

int printk(const char *fmt, ...);

struct semaphore {
	atomic_t count;
	atomic_t waking;
	int lock;			/* to make waking testing atomic */
	struct wait_queue * wait;
};

#define MUTEX ((struct semaphore) { 1, 0, 0, NULL })
#define MUTEX_LOCKED ((struct semaphore) { 0, 0, 0, NULL })

/* the following live in kernel/sched.c */

extern void __down(struct semaphore * sem);
extern int __down_interruptible(struct semaphore * sem);
extern void __up(struct semaphore * sem);

extern inline void down(struct semaphore * sem)
{
  unsigned long flags;
  int failed;
  /* atomically decrement the semaphores count, and if its negative, we wait */
  save_flags(flags);
  cli();
  failed = --(sem->count) < 0;
  restore_flags(flags);
  if(failed) {
    __down(sem);
  }
}

/*
 * Primitives to spin on a lock.  Needed only for SMP version.
 */
extern inline void get_buzz_lock(int *lock_ptr)
{
#ifdef __SMP__
        while (xchg(lock_ptr,1) != 0) ;
#endif
} /* get_buzz_lock */

extern inline void give_buzz_lock(int *lock_ptr)
{
#ifdef __SMP__
        *lock_ptr = 0 ;
#endif
} /* give_buzz_lock */

/*
 * This version waits in interruptible state so that the waiting
 * process can be killed.  The down_interruptible routine
 * returns negative for signalled and zero for semaphore acquired.
 */

extern inline int down_interruptible(struct semaphore * sem)
{
  unsigned long flags;
  int failed;
  /* atomically decrement the semaphores count, and if its negative, we wait */
  save_flags(flags);
  cli();
  failed = --(sem->count) < 0;
  restore_flags(flags);
  if(failed)
    failed = __down_interruptible(sem);
  return(failed);
}

/*
 * Note! This is subtle. We jump to wake people up only if
 * the semaphore was negative (== somebody was waiting on it).
 * The default case (no contention) will result in NO
 * jumps for both down() and up().
 */
extern inline void up(struct semaphore * sem)
{  
  unsigned long flags;
  int wakeup;
  /* atomically increment the semaphores count, and if it was negative, we wake people */
  save_flags(flags);
  cli();
  wakeup = ++(sem->count) <= 0;
  restore_flags(flags);
  if(wakeup) {
    __up(sem);
  }
}

#endif
