/* $Id: segment.h,v 1.5 1999/11/12 11:22:13 pkj Exp $ */

/* this file contains stuff that copies between user and kernel space - since we don't
   have a distinction, these just copy without any fuzz, but they shouldn't be called in
   the first place for performance reasons of course. 
*/

#ifndef _ASM_SEGMENT_H
#define _ASM_SEGMENT_H

#define KERNEL_CS	0x10
#define KERNEL_DS	0x18

#define USER_CS		0x23
#define USER_DS		0x2B

#ifdef __KERNEL__
#ifndef __ASSEMBLY__

/*
 * Uh, these should become the main single-value transfer routines..
 * They automatically use the right size if we just have the right
 * pointer type..
 */
#define put_user(x,ptr) __put_user((unsigned long)(x),(ptr),sizeof(*(ptr)))
#define get_user(ptr) ((__typeof__(*(ptr)))__get_user((ptr),sizeof(*(ptr))))

/*
 * This is a silly but good way to make sure that
 * the __put_user function is indeed always optimized,
 * and that we use the correct sizes..
 */
extern int bad_user_access_length(void);

/*
 * dummy pointer type structure.. gcc won't try to do something strange
 * this way..
 */
struct __segment_dummy { unsigned long a[100]; };
#define __sd(x) ((struct __segment_dummy *) (x))
#define __const_sd(x) ((const struct __segment_dummy *) (x))

static inline void __put_user(unsigned long x, void * y, int size)
{
  switch (size) {
  case 1:
    *(unsigned char *)y = (unsigned char)x;
    break;
  case 2:
    *(unsigned short *)y = (unsigned short)x;
    break;
  case 4:
    *(unsigned long *)y = (unsigned long)x;
    break;
  default:
    bad_user_access_length();
  }
}

static inline unsigned long __get_user(const void * y, int size)
{
  switch (size) {
  case 1:
    return *(unsigned char *)y;
  case 2:
    return *(unsigned short *)y;
  case 4:
    return *(unsigned long *)y;
  default:
    return bad_user_access_length();
  }
}

static inline void __generic_memcpy_tofs(void * to, const void * from, unsigned long n)
{
  memcpy(to, from, n);
}

static inline void __constant_memcpy_tofs(void * to, const void * from, unsigned long n)
{
  memcpy(to, from, n);
}

static inline void __generic_memcpy_fromfs(void * to, const void * from, unsigned long n)
{
  memcpy(to, from, n);
}

static inline void __constant_memcpy_fromfs(void * to, const void * from, unsigned long n)
{
  memcpy(to, from, n);
}

#define memcpy_fromfs(to, from, n) \
(__builtin_constant_p(n) ? \
 __constant_memcpy_fromfs((to),(from),(n)) : \
 __generic_memcpy_fromfs((to),(from),(n)))

#define memcpy_tofs(to, from, n) \
(__builtin_constant_p(n) ? \
 __constant_memcpy_tofs((to),(from),(n)) : \
 __generic_memcpy_tofs((to),(from),(n)))

/*
 * These are deprecated..
 *
 * Use "put_user()" and "get_user()" with the proper pointer types instead.
 */

#define get_fs_byte(addr) __get_user((const unsigned char *)(addr),1)
#define get_fs_word(addr) __get_user((const unsigned short *)(addr),2)
#define get_fs_long(addr) __get_user((const unsigned int *)(addr),4)

#define put_fs_byte(x,addr) __put_user((x),(unsigned char *)(addr),1)
#define put_fs_word(x,addr) __put_user((x),(unsigned short *)(addr),2)
#define put_fs_long(x,addr) __put_user((x),(unsigned int *)(addr),4)

  /* these tell the caller what datasegment we are in.. we always answer the same */

static inline unsigned long get_fs(void)
{
  return USER_DS;
}

static inline unsigned long get_ds(void)
{
  return KERNEL_DS;
}

static inline void set_fs(unsigned long val)
{
}

#endif /* __ASSEMBLY__ */
#endif /* __KERNEL__ */

#endif /* _ASM_SEGMENT_H */
