/* $Id: ptrace.h,v 1.9 1998/12/31 13:20:01 bjornw Exp $ */

#ifndef _ETRAX_PTRACE_H
#define _ETRAX_PTRACE_H

/* this struct defines the way the registers are stored on the 
   stack during a system call. */

struct pt_regs {
  unsigned long orig_r10;
  /* pushed by movem r13, [sp] in SAVE_ALL, movem pushes backwards */
  unsigned long r13; /* 4 */
  unsigned long r12; /* 8 */
  unsigned long r11; /* 12 */
  unsigned long r10; /* 16 */
  unsigned long r9;
  unsigned long r8;
  unsigned long r7;
  unsigned long r6;
  unsigned long r5;
  unsigned long r4;
  unsigned long r3;
  unsigned long r2;
  unsigned long r1;
  unsigned long r0;
  unsigned long dccr;
  unsigned long srp;
  unsigned long irp;
};

/* switch_stack is the extra stuff pushed onto the stack in _resume (entry.S) when
   doing a context-switch. it is used (apart from in resume) when a new thread is made 
   and we need to make _resume (which is starting it for the first time) realise what
   is going on. 
*/

struct switch_stack {
  unsigned long r9;
  unsigned long r8;
  unsigned long r7;
  unsigned long r6;
  unsigned long r5;
  unsigned long r4;
  unsigned long r3;
  unsigned long r2;
  unsigned long r1;
  unsigned long r0;
  unsigned long return_ip;
};

#ifdef __KERNEL__
 /*((VM_MASK & (regs)->eflags) || (3 & (regs)->cs))*/

extern char _edata;
/* we are in user mode if the instruction pointer is above the kernel space.. */
#define user_mode(regs) ((regs)->irp >= (unsigned long)&_edata)
#define instruction_pointer(regs) ((regs)->irp)
extern void show_regs(struct pt_regs *);
#endif

#endif /* _ETRAX_PTRACE.H */
