/* $Id: processor.h,v 1.7 1998/11/06 13:32:17 bjornw Exp $
 *
 * include/asm-etrax100/processor.h
 *
 * Copyright (C) 1998 Axis Communications AB
 */

#ifndef __ASM_ETRAX_PROCESSOR_H
#define __ASM_ETRAX_PROCESSOR_H

#include <asm/system.h>

/*
 * User space process size: 3GB. This is hardcoded into a few places,
 * so don't change it unless you know what you are doing.
 */
#define TASK_SIZE	(0xC0000000UL)

/* this is a preliminary etrax100 thread_struct... */

struct thread_struct {
  unsigned long usp;     /* user stack pointer, used by resume in entry.S */
  unsigned long esp0;    /* points to start of saved stack frame, set in entry.S */  
  unsigned short ccr;              /* saved flag register */
  unsigned short fs;              /* saved fs (sfc, dfc) */
  /*  unsigned long ip;               starting instruction pointer */
};

#define INIT_MMAP { &init_mm, 0, 0x40000000, PAGE_SHARED, VM_READ | VM_WRITE | VM_EXEC }

#define INIT_TSS  { \
   sizeof(init_kernel_stack) + (long) &init_kernel_stack, 0,\
   0x20, KERNEL_DS }  /* ccr = int enable, nothing else */


/* these live in process.c */
unsigned long alloc_kernel_stack();
void free_kernel_stack(unsigned long page);
asmlinkage void set_esp0(unsigned long ssp);

static inline void start_thread(struct pt_regs * regs, unsigned long ip, unsigned long sp)
{
	unsigned long oldsp = rdusp();
	unsigned long splen = (unsigned long)(regs + 1) - oldsp; 
	
	/* reads from user space
	   set_fs(USER_DS);
	*/
	
	/* give the thread a program location */
	
	regs->irp = ip;
	
	/* we are now about to call upon some heavy voodoo magic and copy the stack */

	set_esp0(sp - sizeof(struct pt_regs)); /* for safety, maybe someone uses it after this */
	sp -= splen;
	memcpy((void *)sp, (void *)oldsp, splen);

	/* switch to the copied stack */

	wrusp(sp);
}

/*
 * Return saved PC of a blocked thread.
 */
extern inline unsigned long thread_saved_pc(struct thread_struct *t)
{
  return (unsigned long)((struct pt_regs *)t->esp0)->irp;
}

#endif /* __ASM_ETRAX_PROCESSOR_H */
