/* $Id: irq.h,v 1.13 2000/01/12 19:19:36 bjornw Exp $ */

#ifndef _ASM_IRQ_H
#define _ASM_IRQ_H

/*
 *	linux/include/asm-etrax100/irq.h
 */

#include <linux/linkage.h>
#include <asm/segment.h>

#include <asm/sv_addr_ag.h>

#define NR_IRQS 26   

extern void disable_irq(unsigned int);
extern void enable_irq(unsigned int);

/* our fine, global, etrax irq vector! the pointer lives in the head.c file. */

typedef void (*irqvectptr)();

struct etrax_interrupt_vector {
  irqvectptr v[256];
};

extern struct etrax_interrupt_vector *etrax_irv;
void set_int_vector(int n, irqvectptr addr, irqvectptr saddr);
void set_break_vector(int n, irqvectptr addr);

#define __STR(x) #x
#define STR(x) __STR(x)
 
/* WARNING */
/* SAVE_ALL saves registers so they match pt_regs */
/* it must correspond to the below RESTORE_ALL and the Rexit in entry.S */

#define SAVE_ALL \
  "push irp\n\t" /* push instruction pointer */ \
  "push srp\n\t" /* push subroutine return pointer */ \
  "push dccr\n\t" /* push condition codes */ \
  "di\n\t" \
  "subq 14*4,sp\n\t" /* make room for r0-r13 */ \
  "movem r13,[sp]\n\t" /* push the r0-r13 registers */ \
  "push r10\n\t" /* push orig_r10 */

  /* the following must correspond to the above */

#define RESTORE_ALL \
  "addq 4,sp\n\t" /* skip orig_r10 */ \
  "movem [sp+],r13\n\t" \
  "pop dccr\n\t" \
  "pop srp\n\t" \
  "jump [sp+]\n\t"

/*
 * SAVE_MOST/RESTORE_MOST is used for the faster version of IRQ handlers,
 * installed by using the SA_INTERRUPT flag. These kinds of IRQ's don't
 * call the routines that do signal handling etc on return, and can have
 * more relaxed register-saving etc. They are also atomic, and are thus
 * suited for small, fast interrupts like the serial lines or the harddisk
 * drivers, which don't actually need signal handling etc.
 *
 * TODO we might be able to save less registers here, since etrax gcc preserves
 * r0-r8 in function calls (?).
 *
 */

#define SAVE_MOST \
  "push dccr\n\t" \
  "di\n\t"   /* must do this in a fast irq */ \
  "push srp\n\t" \
  "subq 14*4,sp\n\t" \
  "movem r13,[sp]\n\t" 

#define RESTORE_MOST \
  "movem [sp+],r13\n\t" \
  "pop srp\n\t" \
  "reti\n\t" \
  "pop dccr\n"  /* in reti's delay slot */

  /* BLOCK_IRQ and UNBLOCK_IRQ do the same as mask_irq and unmask_irq in irq.c */

#define BLOCK_IRQ(mask,nr) \
  "move.d " #mask ",r0\n\t" \
  "move.d r0,[0xb00000d8]\n\t" 
  
#define UNBLOCK_IRQ(mask) \
  "move.d " #mask ",r0\n\t" \
  "move.d r0,[0xb00000dc]\n\t" 

#define IRQ_NAME2(nr) nr##_interrupt(void)
#define IRQ_NAME(nr) IRQ_NAME2(IRQ##nr)
#define FAST_IRQ_NAME(nr) IRQ_NAME2(fast_IRQ##nr)
#define sIRQ_NAME(nr) IRQ_NAME2(sIRQ##nr)
#define sFAST_IRQ_NAME(nr) IRQ_NAME2(sfast_IRQ##nr)
#define BAD_IRQ_NAME(nr) IRQ_NAME2(bad_IRQ##nr)


  /* BUILD_IRQ should, for a slow irq, do:
     
     1)  disable IRQ's, save IRP, CCR and all R regs (SAVE_ALL macro)
     2)  acknowledge the IRQ (We don't do this right now! We can't!)
     3)  mask further IRQ's of the same number
     4)  increase intr_count
     5)  enable irq's again
     6)  call do_IRQ with irq number and sp as arguments (r10 and r11)
     7)  disable irq's
     8)  unmask irq's of the same number
     9)  decrease intr_count
     10) jump to ret_from_sys_call

     A fast IRQ calls do_fast_IRQ which doesn't care about the regs, so we don't
     pass it them either. 
  
  */

#define BUILD_IRQ(nr,mask) \
void IRQ_NAME(nr); \
void FAST_IRQ_NAME(nr); \
void sIRQ_NAME(nr); \
void sFAST_IRQ_NAME(nr); \
void BAD_IRQ_NAME(nr); \
__asm__ ( \
          ".text\n\t" \
SYMBOL_NAME_STR(IRQ) #nr "_interrupt:\n\t" \
	  SAVE_ALL \
	  "_sIRQ" #nr "_interrupt:\n\t" /* shortcut for the multiple irq handler */ \
	  BLOCK_IRQ(mask,nr) /* this must be done to prevent irq loops when we ei below */ \
	  "move.d ["SYMBOL_NAME_STR(intr_count)"],r0\n\t" \
	  "addq 1,r0\n\t" \
	  "move.d r0,["SYMBOL_NAME_STR(intr_count)"]\n\t" \
	  "ei\n\t" /* interrupts are now enabled */ \
	  "moveq "#nr",r10\n\t" \
	  "move.d sp,r11\n\t" \
	  "jsr "SYMBOL_NAME_STR(do_IRQ)"\n\t" /* r10 and r11 are arguments */ \
	  "di\n\t"  /* di in case C did something stupid */  \
	  "move.d ["SYMBOL_NAME_STR(intr_count)"],r0\n\t" \
	  "subq 1,r0\n\t" \
	  "move.d r0,["SYMBOL_NAME_STR(intr_count)"]\n\t" \
	  UNBLOCK_IRQ(mask) \
	  "moveq 0,r9\n\t" /* make ret_from_sys_call realise we came from an irq */ \
	  "jump "SYMBOL_NAME_STR(ret_from_sys_call)"\n\t" \
SYMBOL_NAME_STR(fast_IRQ) #nr "_interrupt:\n\t" \
	    SAVE_ALL \
	    "_sfast_IRQ" #nr "_interrupt:\n\t" /* shortcut for the multiple irq handler */ \
	    BLOCK_IRQ(mask,nr) \
	    "move.d ["SYMBOL_NAME_STR(intr_count)"],r0\n\t" \
	    "addq 1,r0\n\t" \
	    "move.d r0,["SYMBOL_NAME_STR(intr_count)"]\n\t" \
	    "moveq "#nr",r10\n\t" \
	    "jsr "SYMBOL_NAME_STR(do_fast_IRQ)"\n\t" \
	    "di\n\t" /* do this in case the C did something stupid */ \
	    "move.d ["SYMBOL_NAME_STR(intr_count)"],r0\n\t" \
	    "subq 1,r0\n\t" \
	    "move.d r0,["SYMBOL_NAME_STR(intr_count)"]\n\t" \
	    UNBLOCK_IRQ(mask) \
	    RESTORE_ALL /* return without jumping to ret_from_sys_call */ \
SYMBOL_NAME_STR(bad_IRQ) #nr "_interrupt:\n\t" \
	    SAVE_MOST \
	    BLOCK_IRQ(mask,nr) \
	    RESTORE_MOST);


#endif  /* _ASM_IRQ_H */
