/* $Id: byteorder.h,v 1.5 1998/12/21 14:19:46 bjornw Exp $ */

#ifndef _ETRAX_BYTEORDER_H
#define _ETRAX_BYTEORDER_H

#undef ntohl
#undef ntohs
#undef htonl
#undef htons

#ifndef __LITTLE_ENDIAN
#define __LITTLE_ENDIAN 1234
#endif

#ifndef __LITTLE_ENDIAN_BITFIELD
#define __LITTLE_ENDIAN_BITFIELD
#endif

extern unsigned long int	ntohl(unsigned long int);
extern unsigned short int	ntohs(unsigned short int);
extern unsigned long int	htonl(unsigned long int);
extern unsigned short int	htons(unsigned short int);

extern __inline__ unsigned long int	__ntohl(unsigned long int);
extern __inline__ unsigned short int	__ntohs(unsigned short int);
extern __inline__ unsigned long int	__constant_ntohl(unsigned long int);
extern __inline__ unsigned short int	__constant_ntohs(unsigned short int);

/* the constant functions don't need to be fast, since they are optimized away by the
 * compiler anyway.
 */

#define __constant_ntohl(x) \
	((unsigned long int)((((unsigned long int)(x) & 0x000000ffU) << 24) | \
			     (((unsigned long int)(x) & 0x0000ff00U) <<  8) | \
			     (((unsigned long int)(x) & 0x00ff0000U) >>  8) | \
			     (((unsigned long int)(x) & 0xff000000U) >> 24)))

#define __constant_ntohs(x) \
	((unsigned short int)((((unsigned short int)(x) & 0x00ff) << 8) | \
			      (((unsigned short int)(x) & 0xff00) >> 8))) \


#if !defined(CONFIG_ETRAX4)

/* on Etrax100, we can use the new instruction SWAPx Rd here */

extern __inline__ unsigned long int
__ntohl(unsigned long int x)
{
	__asm__ ("swapwb %0" : "=r" (x) : "0" (x));
  
	return(x);
}


extern __inline__ unsigned short int
__ntohs(unsigned short int x)
{
	__asm__ ("swapb %0" : "=r" (x) : "0" (x));
	
	return(x);
}

#else 

/* generic C functions */

extern __inline__ unsigned long int
__ntohl(unsigned long int x)
{
	return __constant_ntohl(x);
}

extern __inline__ unsigned short int
__ntohs(unsigned short int x)
{
	return __constant_ntohs(x);
}

#endif

#define __htonl(x) __ntohl(x)
#define __htons(x) __ntohs(x)
#define __constant_htonl(x) __constant_ntohl(x)
#define __constant_htons(x) __constant_ntohs(x)

#ifdef  __OPTIMIZE__
#  define ntohl(x) \
(__builtin_constant_p((long)(x)) ? \
 __constant_ntohl((x)) : \
 __ntohl((x)))
#  define ntohs(x) \
(__builtin_constant_p((short)(x)) ? \
 __constant_ntohs((x)) : \
 __ntohs((x)))
#  define htonl(x) \
(__builtin_constant_p((long)(x)) ? \
 __constant_htonl((x)) : \
 __htonl((x)))
#  define htons(x) \
(__builtin_constant_p((short)(x)) ? \
 __constant_htons((x)) : \
 __htons((x)))
#endif

#endif
